(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    275865,       5455]
NotebookOptionsPosition[    266452,       5316]
NotebookOutlinePosition[    266845,       5332]
CellTagsIndexPosition[    266802,       5329]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"<<", "VilTeX`"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "VilCretas`"}]}], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}, 
   3.967118270989635*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"bba70a38-bbed-491e-a5ca-9778f16b39ce"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118326736744*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"e21ab988-80c4-433f-94a6-53bdc92979e1"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118353095788*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"e3626628-055b-4013-910b-95529446f86e"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118353096479*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"b106a480-96e8-443f-bf16-e74c70578477"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118353096809*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"59a25819-e0f1-4cbd-a768-9998cd868ee6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118353097146*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"c2bd9f5c-fa8a-4b5c-af35-19dc9df5f05f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967118353097624*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"0e2cdf1f-a402-44c0-b758-a789cf7b7081"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.96711835309793*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"6a504144-ea80-4910-bfd5-f5dc605cfee9"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilCretas cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
06/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.9671183531727543`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"a18995c1-ed9f-4467-b7ae-b4c5da4974dd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8. ExportAutomataToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529884602141*^9, 3.966529888912291*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportAutomataToTikZ"}]], "Input",
 CellChangeTimes->{{3.967274639246696*^9, 3.9672746435526667`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"6f7b34e8-b14a-427d-b416-d24fd4ad9427"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportAutomataToTikZ[states, alphabet, \
initialState, transitions, acceptingStates, filename, opts] exporta un aut\
\[OAcute]mata finito determin\[IAcute]stico o no determin\[IAcute]stico como \
c\[OAcute]digo TikZ/LaTeX. \\n\\nPAR\[CapitalAAcute]METROS:\\n- states: Lista \
de estados del aut\[OAcute]mata (ej: {q0, q1, q2} o {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]})\\n- alphabet: Lista de s\[IAcute]mbolos del alfabeto \
de entrada (ej: {0, 1} o {a, b})\\n- initialState: Estado inicial (debe estar \
en la lista de estados)\\n- transitions: Lista de transiciones con formato \
{estadoOrigen, s\[IAcute]mbolo, estadoDestino} o {estadoOrigen, \
s\[IAcute]mbolo, {listaEstadosDestino}}\\n- acceptingStates: Lista de estados \
de aceptaci\[OAcute]n (subconjunto de states)\\n- filename: Nombre del \
archivo .tex a generar (debe terminar en '.tex')\\n\\nOPCIONES \
DISPONIBLES:\\n\\nVISUALIZACI\[CapitalOAcute]N DE ETIQUETAS:\\n- \
\\\"ShowLabels\\\" -> True|False: Muestra/oculta las etiquetas de los estados \
(default: True)\\n\\nTAMA\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\\n- \\\
\"StateSize\\\" -> n\[UAcute]mero: Tama\[NTilde]o de los estados en cm \
(default: 0.8)\\n- \\\"NodeDistance\\\" -> n\[UAcute]mero: Distancia entre \
nodos en cm (default: 4)\\n\\nCOLORES DE ESTADOS:\\n- \\\"StateColor\\\" -> \
\\\"white\\\"|\\\"red\\\"|\\\"blue\\\"|\\\"lightblue\\\"|\\\"lightgreen\\\"|\
etc.: Color de relleno de estados normales (default: \\\"lightblue\\\")\\n- \
\\\"AutoColor\\\" -> True|False: Asigna autom\[AAcute]ticamente colores \
diferentes a cada estado (default: False)\\n\\nESTILO DE TRANSICIONES:\\n- \\\
\"ArrowThickness\\\" -> True|False: Grosor de la flecha inicial. True aplica \
\\\"ultra thick\\\", False usa grosor por defecto (default: True)\\n- \
\\\"TransitionColor\\\" -> color: Color de las transiciones (default: \
\\\"purple\\\")\\n\\nLAYOUT Y POSICIONAMIENTO:\\n- \\\"LayoutStyle\\\" -> \
\\\"circular\\\"|\\\"grid\\\"|\\\"spring\\\": Estilo de disposici\[OAcute]n \
autom\[AAcute]tica (default: \\\"circular\\\")\\n  * \\\"circular\\\": \
Dispone estados en c\[IAcute]rculo\\n  * \\\"grid\\\": Dispone estados en \
rejilla cuadrada ordenada\\n  * \\\"spring\\\": Disposici\[OAcute]n \
pseudoaleatoria tipo resorte\\n\\nELEMENTOS ADICIONALES:\\n- \\\"ShowGrid\\\" \
-> True|False: Muestra rejilla de coordenadas en el fondo con l\[IAcute]neas \
cada 0.5cm (default: False)\\n- \\\"ShowAxes\\\" -> True|False: Muestra ejes \
de coordenadas X/Y en color negro con flechas (default: False)\\n\\nEJEMPLOS \
DE USO:\\n\\nB\[AAcute]sico (aut\[OAcute]mata \
determin\[IAcute]stico):\\nExportAutomataToTikZ[\\n  {q0, q1, q2}, \\n  {a, \
b}, \\n  q0, \\n  {{q0, a, q1}, {q1, b, q2}, {q2, a, q0}}, \\n  {q2},\\n  \
\\\"automata.tex\\\"\\n]\\n\\nAut\[OAcute]mata no \
determin\[IAcute]stico:\\nExportAutomataToTikZ[\\n  {q0, q1, q2}, \\n  {a, \
b}, \\n  q0, \\n  {{q0, a, {q1, q2}}, {q1, b, q0}, {q2, a, q1}}, \\n  {q1, \
q2},\\n  \\\"nfa.tex\\\"\\n]\\n\\nCon opciones \
personalizadas:\\nExportAutomataToTikZ[\\n  {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]}, \\n  {a, b}, \\n  Subscript[\[Sigma], 0], \\n  \
{{Subscript[\[Sigma], 0], a, Subscript[\[Sigma], 1]}}, \\n  {Subscript[\
\[Sigma], 1]},\\n  \\\"automata.tex\\\",\\n  \\\"AutoColor\\\" -> True,\\n  \
\\\"LayoutStyle\\\" -> \\\"grid\\\",\\n  \\\"StateSize\\\" -> 1.0,\\n  \
\\\"ArrowThickness\\\" -> False,\\n  \\\"ShowGrid\\\" -> True,\\n  \
\\\"ShowAxes\\\" -> True\\n]\\n\\nEjemplo con todas las \
opciones:\\nExportAutomataToTikZ[\\n  {q0, q1, q2, q3}, \\n  {0, 1}, \\n  q0, \
\\n  {{q0, 0, q1}, {q0, 1, q2}, {q1, 1, q3}, {q2, 0, q3}}, \\n  {q3},\\n  \
\\\"completo.tex\\\",\\n  \\\"ShowLabels\\\" -> True,\\n  \\\"StateSize\\\" \
-> 0.8,\\n  \\\"NodeDistance\\\" -> 4,\\n  \\\"StateColor\\\" -> \
\\\"lightblue\\\",\\n  \\\"AutoColor\\\" -> False,\\n  \\\"ArrowThickness\\\" \
-> True,\\n  \\\"LayoutStyle\\\" -> \\\"circular\\\",\\n  \\\"TransitionColor\
\\\" -> \\\"purple\\\",\\n  \\\"ShowGrid\\\" -> False,\\n  \\\"ShowAxes\\\" \
-> False\\n]\\n\\nCOLORES SOPORTADOS:\\nColores b\[AAcute]sicos: \\\"red\\\", \
\\\"blue\\\", \\\"green\\\", \\\"orange\\\", \\\"purple\\\", \\\"brown\\\", \
\\\"pink\\\", \\\"cyan\\\", \\\"magenta\\\", \\\"yellow\\\", \\\"black\\\", \
\\\"white\\\", \\\"gray\\\"\\nColores xcolor: \\\"Red\\\", \\\"Blue\\\", \
\\\"Green\\\", \\\"Violet\\\", \\\"Gray\\\", \\\"LightGray\\\", \
\\\"Yellow\\\", \\\"Emerald\\\", \\\"Turquoise\\\", \\\"Lavender\\\", \
\\\"Peach\\\", \\\"Salmon\\\", etc.\\nColores personalizados: \\\"lightblue\\\
\", \\\"lightgreen\\\", \\\"lightyellow\\\", \\\"lightgray\\\", \
\\\"darkgray\\\"\\n\\nFORMATO DE TRANSICIONES:\\nDetermin\[IAcute]sticas: \
{estadoOrigen, s\[IAcute]mbolo, estadoDestino}\\nNo determin\[IAcute]sticas: \
{estadoOrigen, s\[IAcute]mbolo, {listaEstadosDestino}}\\nEjemplos: \\n- {q0, \
\\\"a\\\", q1} representa: desde q0, con s\[IAcute]mbolo 'a', ir a q1\\n- \
{q0, \\\"a\\\", {q1, q2}} representa: desde q0, con s\[IAcute]mbolo 'a', ir a \
q1 Y q2 simult\[AAcute]neamente\\n\\nESTADOS DE \
ACEPTACI\[CapitalOAcute]N:\\nLos estados de aceptaci\[OAcute]n se dibujan con \
doble c\[IAcute]rculo. Pueden ser:\\n- Estados finales \[UAcute]nicos: \
{qf}\\n- M\[UAcute]ltiples estados de aceptaci\[OAcute]n: {q1, q3, q5}  \\n- \
Lista vac\[IAcute]a si no hay estados de aceptaci\[OAcute]n: {}\\n\\nS\
\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\\nLa funci\[OAcute]n convierte \
autom\[AAcute]ticamente s\[IAcute]mbolos de Mathematica a LaTeX:\\n- \
Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \\n- \[Alpha], \[Beta], \[Gamma], \
\[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \[Pi], \[Theta], \[CurlyPhi], \
\[Omega] -> letras griegas correspondientes\\n- S\[IAcute]mbolos Unicode se \
convierten autom\[AAcute]ticamente\\n\\nCOMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\
\\nCuando \\\"AutoColor\\\" -> True:\\n- Cada estado recibe un color \
diferente de la paleta predefinida\\n- Los colores se asignan \
c\[IAcute]clicamente si hay m\[AAcute]s estados que colores\\n- Las \
transiciones toman el color del estado origen\\n- \\\"StateColor\\\" se \
ignora para estados individuales\\n- Estados de aceptaci\[OAcute]n mantienen \
el doble c\[IAcute]rculo pero con color \
asignado\\n\\nCARACTER\[CapitalIAcute]STICAS ESPECIALES DE \
AUT\[CapitalOAcute]MATAS:\\n- Flecha de entrada al estado inicial siempre \
visible\\n- Estados de aceptaci\[OAcute]n se muestran con doble \
c\[IAcute]rculo\\n- Self-loops (transiciones de un estado a s\[IAcute] mismo) \
se dibujan como bucles\\n- Transiciones bidireccionales se curvan autom\
\[AAcute]ticamente para evitar superposici\[OAcute]n\\n- Soporte completo \
para aut\[OAcute]matas no determin\[IAcute]sticos\\n\\nSALIDA:\\nRetorna la \
ruta completa del archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\\nEl archivo incluye un documento LaTeX completo \
listo para compilar con todas las librer\[IAcute]as TikZ necesarias.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportAutomataToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`states_", ",", "VilTeX`Private`alphabet_",
                     ",", "VilTeX`Private`initialState_", ",", 
                    "VilTeX`Private`transitions_", ",", 
                    "VilTeX`Private`acceptingStates_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    "VilTeX`Private`opts___"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`statePositions", ",", 
                    "VilTeX`Private`transitionGroups", ",", 
                    "VilTeX`Private`formatNum", ",", 
                    "VilTeX`Private`cleanStateName", ",", 
                    RowBox[{"VilTeX`Private`showLabels", "=", "True"}], ",", 
                    RowBox[{"VilTeX`Private`stateSize", "=", "0.8`"}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", "=", "4"}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColor", "=", 
                    "\"lightblue\""}], ",", 
                    RowBox[{"VilTeX`Private`autoColor", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`arrowThickness", "=", "True"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", "=", 
                    "\"circular\""}], ",", 
                    
                    RowBox[{"VilTeX`Private`transitionColor", "=", 
                    "\"purple\""}], ",", 
                    RowBox[{"VilTeX`Private`showGrid", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`showAxes", "=", "False"}], ",", 
                    "VilTeX`Private`optionsList", ",", 
                    "VilTeX`Private`numStates", ",", "VilTeX`Private`maxCols",
                     ",", "VilTeX`Private`gridCols", ",", 
                    "VilTeX`Private`gridRows", ",", 
                    "VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`selfLoops", ",", 
                    "VilTeX`Private`regularTransitions", ",", 
                    "VilTeX`Private`multiTransitions", ",", 
                    RowBox[{"VilTeX`Private`automaticLayout", "=", "True"}]}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`cleanNodeName", ",", 
                    "VilTeX`Private`convertSymbolToLaTeX", ",", 
                    "VilTeX`Private`cleanNodeName", ",", 
                    "VilTeX`Private`getStateLabel"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`states", "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}], 
                    "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Los estados deben ser una lista no \
vac\[IAcute]a.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`alphabet", "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`alphabet", "]"}], 
                    "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El alfabeto debe ser una lista no \
vac\[IAcute]a.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`states", ",", 
                    "VilTeX`Private`initialState"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El estado inicial debe estar en la lista de \
estados.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`transitions", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Las transiciones deben ser una lista.\"", "]"}],
                     ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`acceptingStates", 
                    "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"SubsetQ", "[", 
                    
                    RowBox[{"VilTeX`Private`states", ",", 
                    "VilTeX`Private`acceptingStates"}], "]"}]}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Los estados de aceptaci\[OAcute]n deben ser un \
subconjunto de los estados.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El nombre del archivo debe ser un string.\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El nombre del archivo debe terminar en .tex\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Transici\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\" debe tener formato {estado_origen, s\[IAcute]mbolo, \
estado_destino} o {estado_origen, s\[IAcute]mbolo, {estados_destino}}.\""}], 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`states", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Estado origen \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no existe.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`alphabet", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: S\[IAcute]mbolo \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no est\[AAcute] en el alfabeto.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`destinations", "=", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "3"}], 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`destinations", 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"SubsetQ", "[", 
                    
                    RowBox[{"VilTeX`Private`states", ",", 
                    "VilTeX`Private`destinations"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{
                    "\"Error: Estados destino en transici\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\" deben ser estados v\[AAcute]lidos.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";"}],
                     ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`states", ",", 
                    "VilTeX`Private`destinations"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Estado destino \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`destinations", 
                    "]"}], "<>", "\" en transici\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\" no existe.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitions", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`optionsList", "=", 
                    RowBox[{"{", "VilTeX`Private`opts", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"_String", "\[Rule]", "_"}]}], "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`value", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`key", ",", "\"ShowLabels\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showLabels", "=", 
                    "VilTeX`Private`value"}], ",", "\"StateSize\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stateSize", "=", 
                    "VilTeX`Private`value"}], ",", "\"NodeDistance\"", ",", 
                    
                    RowBox[{"VilTeX`Private`nodeDistance", "=", 
                    "VilTeX`Private`value"}], ",", "\"StateColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stateColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"AutoColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`autoColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"ArrowThickness\"", ",", 
                    
                    RowBox[{"VilTeX`Private`arrowThickness", "=", 
                    "VilTeX`Private`value"}], ",", "\"LayoutStyle\"", ",", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", "=", 
                    "VilTeX`Private`value"}], ",", "\"TransitionColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`transitionColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowGrid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showGrid", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowAxes\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "=", 
                    "VilTeX`Private`value"}], ",", "_", ",", "Null"}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}]}], "}"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`colorPalette", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", ",",
                     "\"orange\"", ",", "\"purple\"", ",", "\"brown\"", ",", 
                    "\"pink\"", ",", "\"cyan\"", ",", "\"magenta\"", ",", 
                    "\"lime\"", ",", "\"olive\"", ",", "\"teal\"", ",", 
                    "\"Red\"", ",", "\"Blue\"", ",", "\"Green\"", ",", 
                    "\"Violet\"", ",", "\"Gray\"", ",", "\"LightGray\"", ",", 
                    "\"Yellow\"", ",", "\"Emerald\"", ",", "\"Turquoise\"", 
                    ",", "\"Lavender\"", ",", "\"Peach\"", ",", "\"Salmon\"", 
                    ",", "\"Aquamarine\"", ",", "\"BlueViolet\"", ",", 
                    "\"CornflowerBlue\"", ",", "\"DarkOrchid\"", ",", 
                    "\"ForestGreen\"", ",", "\"Goldenrod\"", ",", 
                    "\"IndianRed\"", ",", "\"MediumBlue\"", ",", 
                    "\"OliveDrab\"", ",", "\"RoyalBlue\"", ",", 
                    "\"SeaGreen\"", ",", "\"SkyBlue\""}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`stateColorMap", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`autoColor", ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`colorIndex", ",", 
                    "VilTeX`Private`assignedColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`colorIndex", "=", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`colorPalette", 
                    "]"}]}], "]"}], "+", "1"}]}], ";", 
                    RowBox[{"VilTeX`Private`assignedColor", "=", 
                    
                    RowBox[{"VilTeX`Private`colorPalette", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`colorIndex", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], "=",
                     "VilTeX`Private`assignedColor"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}], ",", 
                    "0.001`"}], "]"}], ",", "InputForm"}], "]"}], ",", 
                    "\"0\""}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeX", "[", 
                    "VilTeX`Private`sym_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`symStr", ",", 
                    "VilTeX`Private`result"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`symStr", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`sym", ",", "InputForm"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`symStr", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 6]\"", "\[Rule]", 
                    "\"\\\\sigma_6\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 7]\"", "\[Rule]", 
                    "\"\\\\sigma_7\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 8]\"", "\[Rule]", 
                    "\"\\\\sigma_8\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 9]\"", "\[Rule]", 
                    "\"\\\\sigma_9\""}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"Subscript\\\\[\\\\\\\\\\\\[([A-Za-z]+)\\\\], \
([0-9]+)\\\\]\"", "]"}], "\[RuleDelayed]", 
                    RowBox[{"\"\\\\\"", "<>", 
                    RowBox[{"ToLowerCase", "[", "\"$1\"", "]"}], "<>", 
                    "\"_$2\""}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], 
                    ",", 
                    RowBox[{
                    "\"\\\\[Epsilon]\"", "\[Rule]", "\"\\\\varepsilon\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}],
                     ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"\\\\phi\""}], ",", 
                    
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"\\\\omega\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Tau]\"", "\[Rule]", "\"\\\\tau\""}], ",", 
                    
                    RowBox[{"\"\\\\[Rho]\"", "\[Rule]", "\"\\\\rho\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], ",", 
                    
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}], 
                    ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"\\\\phi\""}], 
                    ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"\\\\omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"\"\\\"\"", "\[Rule]", "\"\""}]}], "]"}]}], ";", 
                    "VilTeX`Private`result"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`state_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`cleanName", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`state", ",", "InputForm"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"sigma0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"sigma1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"sigma2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"sigma3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"sigma4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"sigma5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 6]\"", "\[Rule]", 
                    "\"sigma6\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 7]\"", "\[Rule]", 
                    "\"sigma7\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 8]\"", "\[Rule]", 
                    "\"sigma8\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 9]\"", "\[Rule]", 
                    "\"sigma9\""}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"Subscript\\\\[\\\\\\\\\\\\[([A-Za-z]+)\\\\], \
([0-9]+)\\\\]\"", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    RowBox[{"ToLowerCase", "[", "\"$1\"", "]"}], "<>", 
                    "\"$2\""}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"sigma\""}], ",", 
                    
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"alpha\""}], ",", 
                    
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"beta\""}], ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"gamma\""}], ",", 
                    
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"delta\""}], ",", 
                    
                    RowBox[{"\"\\\\[Epsilon]\"", "\[Rule]", "\"epsilon\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"lambda\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"theta\""}], ",", 
                    
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"phi\""}], ",", 
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"delta\""}], ",", 
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", "\"epsilon\""}],
                     ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"lambda\""}], ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"phi\""}], ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"[\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"]\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\",\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\\\\\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"{\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"}\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"$\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"&\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"%\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"#\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"^\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"_\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"~\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\" \"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\\\"\"", "\[Rule]", "\"\""}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringMatchQ", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"^[a-zA-Z].*\"", 
                    "]"}]}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"\"state\"", "<>", "VilTeX`Private`cleanName"}]}],
                     ",", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    
                    RowBox[{"\"state\"", "<>", 
                    "VilTeX`Private`cleanName"}]}]}], "]"}], ";", 
                    "VilTeX`Private`cleanName"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`getStateLabel", "[", 
                    "VilTeX`Private`state_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`label", ",", 
                    "VilTeX`Private`stateStr"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`stateStr", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`state", ",", "InputForm"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`state", ",", 
                    SubscriptBox["_", "_"]}], "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`base", ",", 
                    "VilTeX`Private`index"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`base", "=", 
                    
                    RowBox[{"VilTeX`Private`state", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`index", "=", 
                    
                    RowBox[{"VilTeX`Private`state", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Sigma]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Sigma]\""}]}], ",", 
                    RowBox[{"\"\\\\sigma_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Alpha]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Alpha]\""}]}], ",", 
                    RowBox[{"\"\\\\alpha_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Beta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Beta]\""}]}], ",", 
                    RowBox[{"\"\\\\beta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Gamma]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Gamma]\""}]}], ",", 
                    RowBox[{"\"\\\\gamma_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Delta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Delta]\""}]}], ",", 
                    RowBox[{"\"\\\\delta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[CurlyEpsilon]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Epsilon]\""}]}], ",", 
                    RowBox[{"\"\\\\varepsilon_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Lambda]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Lambda]\""}]}], ",", 
                    RowBox[{"\"\\\\lambda_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Mu]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Mu]\""}]}], ",", 
                    RowBox[{"\"\\\\mu_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Pi]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Pi]\""}]}], ",", 
                    RowBox[{"\"\\\\pi_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Theta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Theta]\""}]}], ",", 
                    RowBox[{"\"\\\\theta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[CurlyPhi]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Phi]\""}]}], ",", 
                    RowBox[{"\"\\\\phi_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Omega]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Omega]\""}]}], ",", 
                    RowBox[{"\"\\\\omega_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "<>", "\"_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}]}], "]"}]}], ";"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`stateStr", ",", "\"Subscript\""}],
                     "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`stateStr", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Alpha], 0]\"", "\[Rule]", 
                    "\"\\\\alpha_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Alpha], 1]\"", "\[Rule]", 
                    "\"\\\\alpha_1\""}], ",", 
                    RowBox[{"\"Subscript[\\\\[Beta], 0]\"", "\[Rule]", 
                    "\"\\\\beta_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Beta], 1]\"", "\[Rule]", 
                    "\"\\\\beta_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Gamma], 0]\"", "\[Rule]", 
                    "\"\\\\gamma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Gamma], 1]\"", "\[Rule]", 
                    "\"\\\\gamma_1\""}]}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`state", "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], ",", 
                    
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}], 
                    ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"\\\\phi\""}], 
                    ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"\\\\omega\""}], ",", 
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Epsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}],
                     ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"\\\\phi\""}], ",", 
                    
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"\\\\omega\""}]}],
                     "}"}]}], "]"}]}], ";"}]}], "]"}]}], "]"}], ";", 
                    "VilTeX`Private`label"}], ",", "\"\""}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`numStates", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`automaticLayout", ",", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", ",", "\"circular\"",
                     ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}], 
                    ",", "\"grid\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`gridCols", "=", 
                    RowBox[{"Ceiling", "[", 
                    SqrtBox["VilTeX`Private`numStates"], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`gridRows", "=", 
                    RowBox[{"Ceiling", "[", 
                    FractionBox[
                    "VilTeX`Private`numStates", "VilTeX`Private`gridCols"], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`row", "=", 
                    RowBox[{"Ceiling", "[", 
                    FractionBox[
                    "VilTeX`Private`i", "VilTeX`Private`gridCols"], "]"}]}], 
                    ",", 
                    RowBox[{"VilTeX`Private`col", "=", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", 
                    "VilTeX`Private`gridCols"}], "]"}], "+", "1"}]}]}], "}"}],
                     ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`col", "-", "1"}], ")"}], " ", 
                    "VilTeX`Private`nodeDistance"}], "-", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`gridCols", "-", "1"}], ")"}], " ",
                     "VilTeX`Private`nodeDistance"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`gridRows", "-", 
                    "VilTeX`Private`row"}], ")"}], " ", 
                    "VilTeX`Private`nodeDistance"}], "-", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`gridRows", "-", "1"}], ")"}], " ",
                     "VilTeX`Private`nodeDistance"}]}]}], "}"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    ",", "\"spring\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`nodeDistance"}], ",", 
                    "VilTeX`Private`nodeDistance"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`numStates", ",", "2"}], "}"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Thread", "[", 
                    RowBox[{"VilTeX`Private`states", "\[Rule]", 
                    "VilTeX`Private`positions"}], "]"}], "]"}]}]}], "]"}], 
                    ",", "_", ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`transitionMap", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`selfLoops", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`symbol", ",", 
                    "VilTeX`Private`destinations"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`symbol", ",", 
                    "VilTeX`Private`destinations"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`destList", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`destList", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "ListQ", "[", "VilTeX`Private`destinations", "]"}], ",", 
                    "VilTeX`Private`destinations", ",", 
                    RowBox[{"{", "VilTeX`Private`destinations", "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dest", "=", 
                    
                    RowBox[{"VilTeX`Private`destList", "\[LeftDoubleBracket]",
                     "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`key"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`origin", "===", 
                    "VilTeX`Private`dest"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`selfLoops", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`symbol"}], "}"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`dest"}], "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`key"}], "]"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], ",", 
                    "VilTeX`Private`symbol"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], "=", 
                    RowBox[{"{", "VilTeX`Private`symbol", "}"}]}]}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`destList", "]"}]}],
                     "}"}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitions", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`selfLoopGroups", "=", 
                    RowBox[{"GroupBy", "[", 
                    RowBox[{"VilTeX`Private`selfLoops", ",", 
                    RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`selfLoops", "=", 
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
                    "VilTeX`Private`selfLoopGroups"}], "]"}]}]}], "]"}], ";", 
                    
                    
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    "\"\\\\begin{tikzpicture}[\\n\""}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  -stealth,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  shorten >=1pt,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  auto,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  node distance=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`nodeDistance", 
                    "]"}], "<>", "\"cm,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  semithick\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"]\\n\\n\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showGrid", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", "VilTeX`Private`maxX",
                     ",", "VilTeX`Private`minY", ",", "VilTeX`Private`maxY", 
                    ",", "VilTeX`Private`gridRange"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", 
                    "VilTeX`Private`maxX"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minY", ",", 
                    "VilTeX`Private`maxY"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`gridRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`minY", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxY", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Rejilla de fondo\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[help lines, step=0.5cm, color=gray!20] \"", 
                    "<>", "\"(-\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\",-\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\") grid (\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\");\\n\\n\""}]}], ";"}]}], "]"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showAxes", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", "VilTeX`Private`maxX",
                     ",", "VilTeX`Private`minY", ",", "VilTeX`Private`maxY", 
                    ",", "VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", 
                    "VilTeX`Private`maxX"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minY", ",", 
                    "VilTeX`Private`maxY"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxX", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minY", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxY", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Ejes de coordenadas\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[thick, ->, color=black] (-\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`xRange", "]"}], 
                    "<>", "\",0) -- (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`xRange", "]"}], 
                    "<>", "\",0) node[right] {$x$};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[thick, ->, color=black] (0,-\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yRange", "]"}], 
                    "<>", "\") -- (0,\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yRange", "]"}], 
                    "<>", "\") node[above] {$y$};\\n\\n\""}]}], ";"}]}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Definir estilos\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\tikzstyle{state}=[circle, draw, minimum size=\"", 
                    "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`stateSize", 
                    "]"}], "<>", "\"cm, fill=\"", "<>", 
                    "VilTeX`Private`stateColor", "<>", "\"]\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\tikzstyle{accepting}=[circle, draw, minimum \
size=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`stateSize", 
                    "]"}], "<>", "\"cm, fill=\"", "<>", 
                    "VilTeX`Private`stateColor", "<>", "\", double]\\n\""}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\tikzstyle{initial}=[circle, draw, minimum size=\"",
                     "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`stateSize", 
                    "]"}], "<>", "\"cm, fill=\"", "<>", 
                    "VilTeX`Private`stateColor", "<>", "\"]\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\tikzstyle{initial accepting}=[circle, draw, \
minimum size=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`stateSize", 
                    "]"}], "<>", "\"cm, fill=\"", "<>", 
                    "VilTeX`Private`stateColor", "<>", 
                    "\", double]\\n\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Estados\\n\""}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`state", "=", 
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`pos", ",", "VilTeX`Private`stateStyle", 
                    ",", "VilTeX`Private`stateLabel", ",", 
                    "VilTeX`Private`nodeName", ",", 
                    "VilTeX`Private`currentStateColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`nodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`stateLabel", "=", 
                    
                    RowBox[{"VilTeX`Private`getStateLabel", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentStateColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`state"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`state", "]"}], ",", 
                    "VilTeX`Private`stateColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`stateStyle", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`state", "===", 
                    "VilTeX`Private`initialState"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`acceptingStates", ",", 
                    "VilTeX`Private`state"}], "]"}]}], ",", 
                    "\"initial accepting\"", ",", 
                    
                    RowBox[{"VilTeX`Private`state", "===", 
                    "VilTeX`Private`initialState"}], ",", "\"initial\"", ",", 
                    
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`acceptingStates", ",", 
                    "VilTeX`Private`state"}], "]"}], ",", "\"accepting\"", 
                    ",", "True", ",", "\"state\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\node[\"", 
                    "<>", "VilTeX`Private`stateStyle", "<>", "\", fill=\"", 
                    "<>", "VilTeX`Private`currentStateColor", "<>", "\"] (\"",
                     "<>", "VilTeX`Private`nodeName", "<>", "\") at (\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "2",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\") {\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`showLabels", "&&", 
                    
                    RowBox[{"VilTeX`Private`stateLabel", "\[NotEqual]", 
                    "\"\""}]}], ",", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"$\"", "<>", 
                    "VilTeX`Private`stateLabel", "<>", "\"$\""}]}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"};\\n\""}]}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\n\""}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`initialPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`initialState", "]"}]}], ",", 
                    "VilTeX`Private`startPos", ",", 
                    "VilTeX`Private`initialNodeName", ",", 
                    "VilTeX`Private`thicknessStyle"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`initialNodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`initialState", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`startPos", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`initialPos", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "-", "1.5`"}], ",", 
                    
                    RowBox[{"VilTeX`Private`initialPos", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`thicknessStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`arrowThickness", "===", "True"}], 
                    ",", "\"ultra thick, \"", ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Flecha inicial\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\draw[\"", 
                    "<>", "VilTeX`Private`thicknessStyle", "<>", 
                    "\"-stealth] (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`startPos", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`startPos", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") -- (\"", "<>", "VilTeX`Private`initialNodeName", 
                    "<>", "\");\\n\\n\""}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`selfLoops", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Self-loops\\n\""}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`state", ",", 
                    "VilTeX`Private`symbols", ",", "VilTeX`Private`symbolStr",
                     ",", "VilTeX`Private`loopDirection", ",", 
                    "VilTeX`Private`nodeName", ",", 
                    "VilTeX`Private`edgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`state", ",", 
                    "VilTeX`Private`symbols"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`selfLoops", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`nodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`edgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`state"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`state", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`symbolStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeX", "/@", 
                    "VilTeX`Private`symbols"}], ",", "\",\""}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`loopDirection", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", "4"}], "]"}],
                     ",", "0", ",", "\"loop above\"", ",", "1", ",", 
                    "\"loop right\"", ",", "2", ",", "\"loop below\"", ",", 
                    "3", ",", "\"loop left\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`nodeName", "<>", "\") edge [\"", 
                    "<>", "VilTeX`Private`loopDirection", "<>", "\", \"", 
                    "<>", "VilTeX`Private`edgeColor", "<>", "\"] node {$\"", 
                    "<>", "VilTeX`Private`symbolStr", "<>", "\"$} (\"", "<>", 
                    "VilTeX`Private`nodeName", "<>", "\");\\n\""}]}], ";"}]}],
                     "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`selfLoops", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\n\""}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitionMap", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Transiciones\\n\""}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`keyList", "=", 
                    
                    RowBox[{"Keys", "[", "VilTeX`Private`transitionMap", 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`processedPairs", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`symbols", ",", "VilTeX`Private`origin", 
                    ",", "VilTeX`Private`dest", ",", 
                    "VilTeX`Private`symbolStr", ",", 
                    "VilTeX`Private`reversePair", ",", 
                    "VilTeX`Private`bidirectional", ",", 
                    "VilTeX`Private`curveAngle", ",", 
                    "VilTeX`Private`isFirstOfPair", ",", 
                    "VilTeX`Private`originNodeName", ",", 
                    "VilTeX`Private`destNodeName", ",", 
                    "VilTeX`Private`originEdgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    
                    RowBox[{"VilTeX`Private`keyList", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`symbols", "=", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`dest"}], "}"}], "=", 
                    "VilTeX`Private`key"}], ";", 
                    RowBox[{"VilTeX`Private`originNodeName", "=", 
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`origin", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destNodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeName", "[", 
                    "VilTeX`Private`dest", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`originEdgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`origin"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`origin", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`symbolStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeX", "/@", 
                    "VilTeX`Private`symbols"}], ",", "\",\""}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`reversePair", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dest", ",", 
                    "VilTeX`Private`origin"}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`bidirectional", "=", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`reversePair"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`isFirstOfPair", "=", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`reversePair"}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`reversePair", ",", 
                    "VilTeX`Private`key"}], "}"}]}], "]"}]}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`bidirectional"}], "||", 
                    "VilTeX`Private`isFirstOfPair"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`originPos", ",", 
                    "VilTeX`Private`destPos", ",", "VilTeX`Private`dx", ",", 
                    "VilTeX`Private`dy", ",", "VilTeX`Private`angle", ",", 
                    RowBox[{"VilTeX`Private`baseAngle", "=", "20"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`originPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`origin", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`dest", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`dx", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`destPos", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`originPos", 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`dy", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`destPos", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`originPos", 
                    "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`angle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`bidirectional", ",", 
                    "VilTeX`Private`baseAngle", ",", 
                    FractionBox["VilTeX`Private`baseAngle", "2"]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`dx", "]"}], "<", 
                    "0.5`"}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", ">", "0"}], ",", 
                    "VilTeX`Private`angle", ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}]}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dx", ">", "0"}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", "\[GreaterEqual]", "0"}], 
                    ",", "VilTeX`Private`angle", ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}]}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", "\[GreaterEqual]", "0"}], 
                    ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}], ",", 
                    "VilTeX`Private`angle"}], "]"}]}]}], "]"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`originNodeName", "<>", 
                    "\") edge [bend left=\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Abs", "[", "VilTeX`Private`curveAngle", "]"}], 
                    "]"}], "<>", "\", \"", "<>", 
                    "VilTeX`Private`originEdgeColor", "<>", 
                    "\"] node [above] {$\"", "<>", "VilTeX`Private`symbolStr",
                     "<>", "\"$} (\"", "<>", "VilTeX`Private`destNodeName", 
                    "<>", "\");\\n\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`bidirectional", ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`reverseSymbols", ",", 
                    "VilTeX`Private`reverseSymbolStr", ",", 
                    "VilTeX`Private`destEdgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`reverseSymbols", "=", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`reversePair", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`reverseSymbolStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeX", "/@", 
                    "VilTeX`Private`reverseSymbols"}], ",", "\",\""}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destEdgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`dest"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`dest", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`destNodeName", "<>", 
                    "\") edge [bend left=\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Abs", "[", "VilTeX`Private`curveAngle", "]"}], 
                    "]"}], "<>", "\", \"", "<>", 
                    "VilTeX`Private`destEdgeColor", "<>", 
                    "\"] node [below] {$\"", "<>", 
                    "VilTeX`Private`reverseSymbolStr", "<>", "\"$} (\"", "<>",
                     "VilTeX`Private`originNodeName", "<>", "\");\\n\""}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`reversePair"}], "}"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`keyList", "]"}]}], 
                    "}"}]}], "]"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage[dvipsnames]{xcolor}\\n\"", "<>", 
                    "\"\\\\usetikzlibrary{automata, positioning, \
arrows}\\n\"", "<>", "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\n% Colores personalizados adicionales\\n\"", "<>", 
                    "\"\\\\definecolor{lightblue}{RGB}{173,216,230}\\n\"", 
                    "<>", "\"\\\\definecolor{lightgreen}{RGB}{144,238,144}\\n\
\"", "<>", "\"\\\\definecolor{lightyellow}{RGB}{255,255,224}\\n\"", "<>", 
                    "\"\\\\definecolor{lightgray}{RGB}{211,211,211}\\n\"", 
                    "<>", "\"\\\\definecolor{darkgray}{RGB}{169,169,169}\\n\"\
", "<>", "\"\\\\definecolor{orange}{RGB}{255,165,0}\\n\"", "<>", 
                    "\"\\\\definecolor{purple}{RGB}{128,0,128}\\n\"", "<>", 
                    "\"\\\\definecolor{pink}{RGB}{255,192,203}\\n\"", "<>", 
                    "\"\\n\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportAutomataToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportAutomataToTikZ[states, alphabet, \
initialState, transitions, acceptingStates, filename, opts] exporta un aut\
\[OAcute]mata finito determin\[IAcute]stico o no determin\[IAcute]stico como \
c\[OAcute]digo TikZ/LaTeX. \\n\\nPAR\[CapitalAAcute]METROS:\\n- states: Lista \
de estados del aut\[OAcute]mata (ej: {q0, q1, q2} o {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]})\\n- alphabet: Lista de s\[IAcute]mbolos del alfabeto \
de entrada (ej: {0, 1} o {a, b})\\n- initialState: Estado inicial (debe estar \
en la lista de estados)\\n- transitions: Lista de transiciones con formato \
{estadoOrigen, s\[IAcute]mbolo, estadoDestino} o {estadoOrigen, \
s\[IAcute]mbolo, {listaEstadosDestino}}\\n- acceptingStates: Lista de estados \
de aceptaci\[OAcute]n (subconjunto de states)\\n- filename: Nombre del \
archivo .tex a generar (debe terminar en '.tex')\\n\\nOPCIONES \
DISPONIBLES:\\n\\nVISUALIZACI\[CapitalOAcute]N DE ETIQUETAS:\\n- \
\\\"ShowLabels\\\" -> True|False: Muestra/oculta las etiquetas de los estados \
(default: True)\\n\\nTAMA\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\\n- \\\
\"StateSize\\\" -> n\[UAcute]mero: Tama\[NTilde]o de los estados en cm \
(default: 0.8)\\n- \\\"NodeDistance\\\" -> n\[UAcute]mero: Distancia entre \
nodos en cm (default: 4)\\n\\nCOLORES DE ESTADOS:\\n- \\\"StateColor\\\" -> \
\\\"white\\\"|\\\"red\\\"|\\\"blue\\\"|\\\"lightblue\\\"|\\\"lightgreen\\\"|\
etc.: Color de relleno de estados normales (default: \\\"lightblue\\\")\\n- \
\\\"AutoColor\\\" -> True|False: Asigna autom\[AAcute]ticamente colores \
diferentes a cada estado (default: False)\\n\\nESTILO DE TRANSICIONES:\\n- \\\
\"ArrowThickness\\\" -> True|False: Grosor de la flecha inicial. True aplica \
\\\"ultra thick\\\", False usa grosor por defecto (default: True)\\n- \
\\\"TransitionColor\\\" -> color: Color de las transiciones (default: \
\\\"purple\\\")\\n\\nLAYOUT Y POSICIONAMIENTO:\\n- \\\"LayoutStyle\\\" -> \
\\\"circular\\\"|\\\"grid\\\"|\\\"spring\\\": Estilo de disposici\[OAcute]n \
autom\[AAcute]tica (default: \\\"circular\\\")\\n  * \\\"circular\\\": \
Dispone estados en c\[IAcute]rculo\\n  * \\\"grid\\\": Dispone estados en \
rejilla cuadrada ordenada\\n  * \\\"spring\\\": Disposici\[OAcute]n \
pseudoaleatoria tipo resorte\\n\\nELEMENTOS ADICIONALES:\\n- \\\"ShowGrid\\\" \
-> True|False: Muestra rejilla de coordenadas en el fondo con l\[IAcute]neas \
cada 0.5cm (default: False)\\n- \\\"ShowAxes\\\" -> True|False: Muestra ejes \
de coordenadas X/Y en color negro con flechas (default: False)\\n\\nEJEMPLOS \
DE USO:\\n\\nB\[AAcute]sico (aut\[OAcute]mata \
determin\[IAcute]stico):\\nExportAutomataToTikZ[\\n  {q0, q1, q2}, \\n  {a, \
b}, \\n  q0, \\n  {{q0, a, q1}, {q1, b, q2}, {q2, a, q0}}, \\n  {q2},\\n  \
\\\"automata.tex\\\"\\n]\\n\\nAut\[OAcute]mata no \
determin\[IAcute]stico:\\nExportAutomataToTikZ[\\n  {q0, q1, q2}, \\n  {a, \
b}, \\n  q0, \\n  {{q0, a, {q1, q2}}, {q1, b, q0}, {q2, a, q1}}, \\n  {q1, \
q2},\\n  \\\"nfa.tex\\\"\\n]\\n\\nCon opciones \
personalizadas:\\nExportAutomataToTikZ[\\n  {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]}, \\n  {a, b}, \\n  Subscript[\[Sigma], 0], \\n  \
{{Subscript[\[Sigma], 0], a, Subscript[\[Sigma], 1]}}, \\n  {Subscript[\
\[Sigma], 1]},\\n  \\\"automata.tex\\\",\\n  \\\"AutoColor\\\" -> True,\\n  \
\\\"LayoutStyle\\\" -> \\\"grid\\\",\\n  \\\"StateSize\\\" -> 1.0,\\n  \
\\\"ArrowThickness\\\" -> False,\\n  \\\"ShowGrid\\\" -> True,\\n  \
\\\"ShowAxes\\\" -> True\\n]\\n\\nEjemplo con todas las \
opciones:\\nExportAutomataToTikZ[\\n  {q0, q1, q2, q3}, \\n  {0, 1}, \\n  q0, \
\\n  {{q0, 0, q1}, {q0, 1, q2}, {q1, 1, q3}, {q2, 0, q3}}, \\n  {q3},\\n  \
\\\"completo.tex\\\",\\n  \\\"ShowLabels\\\" -> True,\\n  \\\"StateSize\\\" \
-> 0.8,\\n  \\\"NodeDistance\\\" -> 4,\\n  \\\"StateColor\\\" -> \
\\\"lightblue\\\",\\n  \\\"AutoColor\\\" -> False,\\n  \\\"ArrowThickness\\\" \
-> True,\\n  \\\"LayoutStyle\\\" -> \\\"circular\\\",\\n  \\\"TransitionColor\
\\\" -> \\\"purple\\\",\\n  \\\"ShowGrid\\\" -> False,\\n  \\\"ShowAxes\\\" \
-> False\\n]\\n\\nCOLORES SOPORTADOS:\\nColores b\[AAcute]sicos: \\\"red\\\", \
\\\"blue\\\", \\\"green\\\", \\\"orange\\\", \\\"purple\\\", \\\"brown\\\", \
\\\"pink\\\", \\\"cyan\\\", \\\"magenta\\\", \\\"yellow\\\", \\\"black\\\", \
\\\"white\\\", \\\"gray\\\"\\nColores xcolor: \\\"Red\\\", \\\"Blue\\\", \
\\\"Green\\\", \\\"Violet\\\", \\\"Gray\\\", \\\"LightGray\\\", \
\\\"Yellow\\\", \\\"Emerald\\\", \\\"Turquoise\\\", \\\"Lavender\\\", \
\\\"Peach\\\", \\\"Salmon\\\", etc.\\nColores personalizados: \\\"lightblue\\\
\", \\\"lightgreen\\\", \\\"lightyellow\\\", \\\"lightgray\\\", \
\\\"darkgray\\\"\\n\\nFORMATO DE TRANSICIONES:\\nDetermin\[IAcute]sticas: \
{estadoOrigen, s\[IAcute]mbolo, estadoDestino}\\nNo determin\[IAcute]sticas: \
{estadoOrigen, s\[IAcute]mbolo, {listaEstadosDestino}}\\nEjemplos: \\n- {q0, \
\\\"a\\\", q1} representa: desde q0, con s\[IAcute]mbolo 'a', ir a q1\\n- \
{q0, \\\"a\\\", {q1, q2}} representa: desde q0, con s\[IAcute]mbolo 'a', ir a \
q1 Y q2 simult\[AAcute]neamente\\n\\nESTADOS DE \
ACEPTACI\[CapitalOAcute]N:\\nLos estados de aceptaci\[OAcute]n se dibujan con \
doble c\[IAcute]rculo. Pueden ser:\\n- Estados finales \[UAcute]nicos: \
{qf}\\n- M\[UAcute]ltiples estados de aceptaci\[OAcute]n: {q1, q3, q5}  \\n- \
Lista vac\[IAcute]a si no hay estados de aceptaci\[OAcute]n: {}\\n\\nS\
\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\\nLa funci\[OAcute]n convierte \
autom\[AAcute]ticamente s\[IAcute]mbolos de Mathematica a LaTeX:\\n- \
Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \\n- \[Alpha], \[Beta], \[Gamma], \
\[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \[Pi], \[Theta], \[CurlyPhi], \
\[Omega] -> letras griegas correspondientes\\n- S\[IAcute]mbolos Unicode se \
convierten autom\[AAcute]ticamente\\n\\nCOMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\
\\nCuando \\\"AutoColor\\\" -> True:\\n- Cada estado recibe un color \
diferente de la paleta predefinida\\n- Los colores se asignan \
c\[IAcute]clicamente si hay m\[AAcute]s estados que colores\\n- Las \
transiciones toman el color del estado origen\\n- \\\"StateColor\\\" se \
ignora para estados individuales\\n- Estados de aceptaci\[OAcute]n mantienen \
el doble c\[IAcute]rculo pero con color \
asignado\\n\\nCARACTER\[CapitalIAcute]STICAS ESPECIALES DE \
AUT\[CapitalOAcute]MATAS:\\n- Flecha de entrada al estado inicial siempre \
visible\\n- Estados de aceptaci\[OAcute]n se muestran con doble \
c\[IAcute]rculo\\n- Self-loops (transiciones de un estado a s\[IAcute] mismo) \
se dibujan como bucles\\n- Transiciones bidireccionales se curvan autom\
\[AAcute]ticamente para evitar superposici\[OAcute]n\\n- Soporte completo \
para aut\[OAcute]matas no determin\[IAcute]sticos\\n\\nSALIDA:\\nRetorna la \
ruta completa del archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\\nEl archivo incluye un documento LaTeX completo \
listo para compilar con todas las librer\[IAcute]as TikZ necesarias.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportAutomataToTikZ[states, alphabet, initialState, transitions, \
acceptingStates, filename, opts] exporta un aut\[OAcute]mata finito determin\
\[IAcute]stico o no determin\[IAcute]stico como c\[OAcute]digo TikZ/LaTeX. \n\
\nPAR\[CapitalAAcute]METROS:\n- states: Lista de estados del aut\[OAcute]mata \
(ej: {q0, q1, q2} o {Subscript[\[Sigma], 0], Subscript[\[Sigma], 1]})\n- \
alphabet: Lista de s\[IAcute]mbolos del alfabeto de entrada (ej: {0, 1} o {a, \
b})\n- initialState: Estado inicial (debe estar en la lista de estados)\n- \
transitions: Lista de transiciones con formato {estadoOrigen, \
s\[IAcute]mbolo, estadoDestino} o {estadoOrigen, s\[IAcute]mbolo, \
{listaEstadosDestino}}\n- acceptingStates: Lista de estados de aceptaci\
\[OAcute]n (subconjunto de states)\n- filename: Nombre del archivo .tex a \
generar (debe terminar en '.tex')\n\nOPCIONES DISPONIBLES:\n\nVISUALIZACI\
\[CapitalOAcute]N DE ETIQUETAS:\n- \"ShowLabels\" -> True|False: \
Muestra/oculta las etiquetas de los estados (default: True)\n\nTAMA\
\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\n- \"StateSize\" -> \
n\[UAcute]mero: Tama\[NTilde]o de los estados en cm (default: 0.8)\n- \
\"NodeDistance\" -> n\[UAcute]mero: Distancia entre nodos en cm (default: 4)\n\
\nCOLORES DE ESTADOS:\n- \"StateColor\" -> \
\"white\"|\"red\"|\"blue\"|\"lightblue\"|\"lightgreen\"|etc.: Color de \
relleno de estados normales (default: \"lightblue\")\n- \"AutoColor\" -> \
True|False: Asigna autom\[AAcute]ticamente colores diferentes a cada estado \
(default: False)\n\nESTILO DE TRANSICIONES:\n- \"ArrowThickness\" -> \
True|False: Grosor de la flecha inicial. True aplica \"ultra thick\", False \
usa grosor por defecto (default: True)\n- \"TransitionColor\" -> color: Color \
de las transiciones (default: \"purple\")\n\nLAYOUT Y POSICIONAMIENTO:\n- \
\"LayoutStyle\" -> \"circular\"|\"grid\"|\"spring\": Estilo de disposici\
\[OAcute]n autom\[AAcute]tica (default: \"circular\")\n  * \"circular\": \
Dispone estados en c\[IAcute]rculo\n  * \"grid\": Dispone estados en rejilla \
cuadrada ordenada\n  * \"spring\": Disposici\[OAcute]n pseudoaleatoria tipo \
resorte\n\nELEMENTOS ADICIONALES:\n- \"ShowGrid\" -> True|False: Muestra \
rejilla de coordenadas en el fondo con l\[IAcute]neas cada 0.5cm (default: \
False)\n- \"ShowAxes\" -> True|False: Muestra ejes de coordenadas X/Y en \
color negro con flechas (default: False)\n\nEJEMPLOS DE USO:\n\n\
B\[AAcute]sico (aut\[OAcute]mata determin\[IAcute]stico):\n\
ExportAutomataToTikZ[\n  {q0, q1, q2}, \n  {a, b}, \n  q0, \n  {{q0, a, q1}, \
{q1, b, q2}, {q2, a, q0}}, \n  {q2},\n  \"automata.tex\"\n]\n\n\
Aut\[OAcute]mata no determin\[IAcute]stico:\nExportAutomataToTikZ[\n  {q0, \
q1, q2}, \n  {a, b}, \n  q0, \n  {{q0, a, {q1, q2}}, {q1, b, q0}, {q2, a, \
q1}}, \n  {q1, q2},\n  \"nfa.tex\"\n]\n\nCon opciones personalizadas:\n\
ExportAutomataToTikZ[\n  {Subscript[\[Sigma], 0], Subscript[\[Sigma], 1]}, \n \
 {a, b}, \n  Subscript[\[Sigma], 0], \n  {{Subscript[\[Sigma], 0], a, \
Subscript[\[Sigma], 1]}}, \n  {Subscript[\[Sigma], 1]},\n  \"automata.tex\",\n\
  \"AutoColor\" -> True,\n  \"LayoutStyle\" -> \"grid\",\n  \"StateSize\" -> \
1.0,\n  \"ArrowThickness\" -> False,\n  \"ShowGrid\" -> True,\n  \"ShowAxes\" \
-> True\n]\n\nEjemplo con todas las opciones:\nExportAutomataToTikZ[\n  {q0, \
q1, q2, q3}, \n  {0, 1}, \n  q0, \n  {{q0, 0, q1}, {q0, 1, q2}, {q1, 1, q3}, \
{q2, 0, q3}}, \n  {q3},\n  \"completo.tex\",\n  \"ShowLabels\" -> True,\n  \
\"StateSize\" -> 0.8,\n  \"NodeDistance\" -> 4,\n  \"StateColor\" -> \
\"lightblue\",\n  \"AutoColor\" -> False,\n  \"ArrowThickness\" -> True,\n  \
\"LayoutStyle\" -> \"circular\",\n  \"TransitionColor\" -> \"purple\",\n  \
\"ShowGrid\" -> False,\n  \"ShowAxes\" -> False\n]\n\nCOLORES SOPORTADOS:\n\
Colores b\[AAcute]sicos: \"red\", \"blue\", \"green\", \"orange\", \
\"purple\", \"brown\", \"pink\", \"cyan\", \"magenta\", \"yellow\", \
\"black\", \"white\", \"gray\"\nColores xcolor: \"Red\", \"Blue\", \"Green\", \
\"Violet\", \"Gray\", \"LightGray\", \"Yellow\", \"Emerald\", \"Turquoise\", \
\"Lavender\", \"Peach\", \"Salmon\", etc.\nColores personalizados: \
\"lightblue\", \"lightgreen\", \"lightyellow\", \"lightgray\", \"darkgray\"\n\
\nFORMATO DE TRANSICIONES:\nDetermin\[IAcute]sticas: {estadoOrigen, \
s\[IAcute]mbolo, estadoDestino}\nNo determin\[IAcute]sticas: {estadoOrigen, s\
\[IAcute]mbolo, {listaEstadosDestino}}\nEjemplos: \n- {q0, \"a\", q1} \
representa: desde q0, con s\[IAcute]mbolo 'a', ir a q1\n- {q0, \"a\", {q1, \
q2}} representa: desde q0, con s\[IAcute]mbolo 'a', ir a q1 Y q2 simult\
\[AAcute]neamente\n\nESTADOS DE ACEPTACI\[CapitalOAcute]N:\nLos estados de \
aceptaci\[OAcute]n se dibujan con doble c\[IAcute]rculo. Pueden ser:\n- \
Estados finales \[UAcute]nicos: {qf}\n- M\[UAcute]ltiples estados de aceptaci\
\[OAcute]n: {q1, q3, q5}  \n- Lista vac\[IAcute]a si no hay estados de \
aceptaci\[OAcute]n: {}\n\nS\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\nLa \
funci\[OAcute]n convierte autom\[AAcute]ticamente s\[IAcute]mbolos de \
Mathematica a LaTeX:\n- Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \n- \
\[Alpha], \[Beta], \[Gamma], \[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \
\[Pi], \[Theta], \[CurlyPhi], \[Omega] -> letras griegas correspondientes\n- \
S\[IAcute]mbolos Unicode se convierten autom\[AAcute]ticamente\n\n\
COMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\nCuando \"AutoColor\" -> True:\n- Cada \
estado recibe un color diferente de la paleta predefinida\n- Los colores se \
asignan c\[IAcute]clicamente si hay m\[AAcute]s estados que colores\n- Las \
transiciones toman el color del estado origen\n- \"StateColor\" se ignora \
para estados individuales\n- Estados de aceptaci\[OAcute]n mantienen el doble \
c\[IAcute]rculo pero con color asignado\n\nCARACTER\[CapitalIAcute]STICAS \
ESPECIALES DE AUT\[CapitalOAcute]MATAS:\n- Flecha de entrada al estado \
inicial siempre visible\n- Estados de aceptaci\[OAcute]n se muestran con \
doble c\[IAcute]rculo\n- Self-loops (transiciones de un estado a s\[IAcute] \
mismo) se dibujan como bucles\n- Transiciones bidireccionales se curvan autom\
\[AAcute]ticamente para evitar superposici\[OAcute]n\n- Soporte completo para \
aut\[OAcute]matas no determin\[IAcute]sticos\n\nSALIDA:\nRetorna la ruta \
completa del archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\nEl archivo incluye un documento LaTeX completo \
listo para compilar con todas las librer\[IAcute]as TikZ necesarias.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportAutomataToTikZ, {VilTeX`ExportAutomataToTikZ[
         Pattern[VilTeX`Private`states, 
          Blank[]], 
         Pattern[VilTeX`Private`alphabet, 
          Blank[]], 
         Pattern[VilTeX`Private`initialState, 
          Blank[]], 
         Pattern[VilTeX`Private`transitions, 
          Blank[]], 
         Pattern[VilTeX`Private`acceptingStates, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Pattern[VilTeX`Private`opts, 
          BlankNullSequence[]]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderName, 
          VilTeX`Private`folderPath, VilTeX`Private`statePositions, 
          VilTeX`Private`transitionGroups, VilTeX`Private`formatNum, 
          VilTeX`Private`cleanStateName, VilTeX`Private`showLabels = True, 
          VilTeX`Private`stateSize = 0.8, VilTeX`Private`nodeDistance = 4, 
          VilTeX`Private`stateColor = "lightblue", VilTeX`Private`autoColor = 
          False, VilTeX`Private`arrowThickness = True, 
          VilTeX`Private`layoutStyle = "circular", 
          VilTeX`Private`transitionColor = "purple", VilTeX`Private`showGrid = 
          False, VilTeX`Private`showAxes = False, VilTeX`Private`optionsList, 
          VilTeX`Private`numStates, VilTeX`Private`maxCols, 
          VilTeX`Private`gridCols, VilTeX`Private`gridRows, 
          VilTeX`Private`transitionMap, VilTeX`Private`selfLoops, 
          VilTeX`Private`regularTransitions, VilTeX`Private`multiTransitions, 
          VilTeX`Private`automaticLayout = True}, 
         Clear[VilTeX`Private`stateColorMap, VilTeX`Private`cleanNodeName, 
           VilTeX`Private`convertSymbolToLaTeX, VilTeX`Private`cleanNodeName, 
           VilTeX`Private`getStateLabel]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`states]], Length[VilTeX`Private`states] == 
            0], Print[
            "Error: Los estados deben ser una lista no vac\[IAcute]a."]; 
           Return[$Failed]]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`alphabet]], Length[VilTeX`Private`alphabet] == 
            0], Print[
            "Error: El alfabeto debe ser una lista no vac\[IAcute]a."]; 
           Return[$Failed]]; If[
           Not[
            MemberQ[VilTeX`Private`states, VilTeX`Private`initialState]], 
           Print["Error: El estado inicial debe estar en la lista de \
estados."]; Return[$Failed]]; If[
           Not[
            ListQ[VilTeX`Private`transitions]], 
           Print["Error: Las transiciones deben ser una lista."]; 
           Return[$Failed]]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`acceptingStates]], 
            Not[
             SubsetQ[VilTeX`Private`states, VilTeX`Private`acceptingStates]]],
            Print["Error: Los estados de aceptaci\[OAcute]n deben ser un \
subconjunto de los estados."]; Return[$Failed]]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Print["Error: El nombre del archivo debe ser un string."]; 
           Return[$Failed]]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: El nombre del archivo debe terminar en .tex"]; 
           Return[$Failed]]; Do[If[
             Not[
              MatchQ[
               Part[VilTeX`Private`transitions, VilTeX`Private`i], {
                Blank[], 
                Blank[], 
                Blank[]}]], 
             Print["Error: Transici\[OAcute]n " <> ToString[VilTeX`Private`i] <> 
               " debe tener formato {estado_origen, s\[IAcute]mbolo, \
estado_destino} o {estado_origen, s\[IAcute]mbolo, {estados_destino}}."]; 
             Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`states, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 1]]], 
             Print["Error: Estado origen " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 1]] <> 
               " no existe."]; Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`alphabet, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 2]]], 
             Print["Error: S\[IAcute]mbolo " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 2]] <> 
               " no est\[AAcute] en el alfabeto."]; Return[$Failed]]; 
           Module[{VilTeX`Private`destinations = 
              Part[VilTeX`Private`transitions, VilTeX`Private`i, 3]}, If[
               ListQ[VilTeX`Private`destinations], If[
                 Not[
                  SubsetQ[
                  VilTeX`Private`states, VilTeX`Private`destinations]], 
                 Print["Error: Estados destino en transici\[OAcute]n " <> 
                   ToString[VilTeX`Private`i] <> 
                   " deben ser estados v\[AAcute]lidos."]; Return[$Failed]]; 
               Null, If[
                 Not[
                  MemberQ[
                  VilTeX`Private`states, VilTeX`Private`destinations]], 
                 Print["Error: Estado destino " <> 
                   ToString[VilTeX`Private`destinations] <> 
                   " en transici\[OAcute]n " <> ToString[VilTeX`Private`i] <> 
                   " no existe."]; Return[$Failed]]; Null]; Null]; Null, {
           VilTeX`Private`i, 
            Length[VilTeX`Private`transitions]}]; 
         VilTeX`Private`optionsList = {VilTeX`Private`opts}; 
         If[Length[VilTeX`Private`optionsList] > 0, 
           Do[
            If[
             MatchQ[
              Part[VilTeX`Private`optionsList, VilTeX`Private`i], 
              Blank[String] -> Blank[]], 
             
             Module[{VilTeX`Private`key = 
               Part[VilTeX`Private`optionsList, VilTeX`Private`i, 1], 
               VilTeX`Private`value = 
               Part[VilTeX`Private`optionsList, VilTeX`Private`i, 2]}, 
              Switch[
              VilTeX`Private`key, "ShowLabels", VilTeX`Private`showLabels = 
               VilTeX`Private`value, "StateSize", VilTeX`Private`stateSize = 
               VilTeX`Private`value, "NodeDistance", 
               VilTeX`Private`nodeDistance = VilTeX`Private`value, 
               "StateColor", VilTeX`Private`stateColor = VilTeX`Private`value,
                "AutoColor", VilTeX`Private`autoColor = VilTeX`Private`value, 
               "ArrowThickness", VilTeX`Private`arrowThickness = 
               VilTeX`Private`value, "LayoutStyle", 
               VilTeX`Private`layoutStyle = VilTeX`Private`value, 
               "TransitionColor", VilTeX`Private`transitionColor = 
               VilTeX`Private`value, "ShowGrid", VilTeX`Private`showGrid = 
               VilTeX`Private`value, "ShowAxes", VilTeX`Private`showAxes = 
               VilTeX`Private`value, 
               Blank[], Null]]], {VilTeX`Private`i, 
             Length[VilTeX`Private`optionsList]}]]; 
         VilTeX`Private`colorPalette = {
           "red", "blue", "green", "orange", "purple", "brown", "pink", 
            "cyan", "magenta", "lime", "olive", "teal", "Red", "Blue", 
            "Green", "Violet", "Gray", "LightGray", "Yellow", "Emerald", 
            "Turquoise", "Lavender", "Peach", "Salmon", "Aquamarine", 
            "BlueViolet", "CornflowerBlue", "DarkOrchid", "ForestGreen", 
            "Goldenrod", "IndianRed", "MediumBlue", "OliveDrab", "RoyalBlue", 
            "SeaGreen", "SkyBlue"}; VilTeX`Private`stateColorMap = <||>; 
         If[VilTeX`Private`autoColor, Do[
             
             Module[{VilTeX`Private`colorIndex, VilTeX`Private`assignedColor},
               VilTeX`Private`colorIndex = Mod[VilTeX`Private`i - 1, 
                  Length[VilTeX`Private`colorPalette]] + 1; 
              VilTeX`Private`assignedColor = 
               Part[VilTeX`Private`colorPalette, VilTeX`Private`colorIndex]; 
              VilTeX`Private`stateColorMap[
                 Part[VilTeX`Private`states, VilTeX`Private`i]] = 
               VilTeX`Private`assignedColor; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`states]}]; Null]; VilTeX`Private`formatNum[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := If[
            NumericQ[VilTeX`Private`x], 
            ToString[
             Round[
              N[VilTeX`Private`x], 0.001], InputForm], "0"]; 
         VilTeX`Private`convertSymbolToLaTeX[
            Pattern[VilTeX`Private`sym, 
             Blank[]]] := 
          Module[{VilTeX`Private`symStr, VilTeX`Private`result}, 
            VilTeX`Private`symStr = ToString[VilTeX`Private`sym, InputForm]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`symStr, {
               "Subscript[\\[Sigma], 0]" -> "\\sigma_0", 
                "Subscript[\\[Sigma], 1]" -> "\\sigma_1", 
                "Subscript[\\[Sigma], 2]" -> "\\sigma_2", 
                "Subscript[\\[Sigma], 3]" -> "\\sigma_3", 
                "Subscript[\\[Sigma], 4]" -> "\\sigma_4", 
                "Subscript[\\[Sigma], 5]" -> "\\sigma_5", 
                "Subscript[\\[Sigma], 6]" -> "\\sigma_6", 
                "Subscript[\\[Sigma], 7]" -> "\\sigma_7", 
                "Subscript[\\[Sigma], 8]" -> "\\sigma_8", 
                "Subscript[\\[Sigma], 9]" -> "\\sigma_9"}]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, 
               RegularExpression[
                "Subscript\\[\\\\\\[([A-Za-z]+)\\], ([0-9]+)\\]"] :> 
               "\\" <> ToLowerCase["$1"] <> "_$2"]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, {
               "\\[Sigma]" -> "\\sigma", "\\[Alpha]" -> "\\alpha", "\\[Beta]" -> 
                "\\beta", "\\[Gamma]" -> "\\gamma", "\\[Delta]" -> "\\delta", 
                "\\[Epsilon]" -> "\\varepsilon", "\\[Lambda]" -> "\\lambda", 
                "\\[Mu]" -> "\\mu", "\\[Pi]" -> "\\pi", "\\[Theta]" -> 
                "\\theta", "\\[Phi]" -> "\\phi", "\\[Omega]" -> "\\omega", 
                "\\[Tau]" -> "\\tau", "\\[Rho]" -> "\\rho"}]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, {
               "\[Sigma]" -> "\\sigma", "\[Alpha]" -> "\\alpha", "\[Beta]" -> 
                "\\beta", "\[Gamma]" -> "\\gamma", "\[Delta]" -> "\\delta", 
                "\[CurlyEpsilon]" -> "\\varepsilon", "\[Lambda]" -> 
                "\\lambda", "\[Mu]" -> "\\mu", "\[Pi]" -> "\\pi", "\[Theta]" -> 
                "\\theta", "\[CurlyPhi]" -> "\\phi", "\[Omega]" -> 
                "\\omega"}]; 
            VilTeX`Private`result = 
             StringReplace[VilTeX`Private`result, "\"" -> ""]; 
            VilTeX`Private`result]; VilTeX`Private`cleanNodeName[
            Pattern[VilTeX`Private`state, 
             Blank[]]] := 
          Module[{VilTeX`Private`cleanName}, 
            VilTeX`Private`cleanName = 
             ToString[VilTeX`Private`state, InputForm]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "Subscript[\\[Sigma], 0]" -> "sigma0", 
                "Subscript[\\[Sigma], 1]" -> "sigma1", 
                "Subscript[\\[Sigma], 2]" -> "sigma2", 
                "Subscript[\\[Sigma], 3]" -> "sigma3", 
                "Subscript[\\[Sigma], 4]" -> "sigma4", 
                "Subscript[\\[Sigma], 5]" -> "sigma5", 
                "Subscript[\\[Sigma], 6]" -> "sigma6", 
                "Subscript[\\[Sigma], 7]" -> "sigma7", 
                "Subscript[\\[Sigma], 8]" -> "sigma8", 
                "Subscript[\\[Sigma], 9]" -> "sigma9"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, 
               RegularExpression[
                "Subscript\\[\\\\\\[([A-Za-z]+)\\], ([0-9]+)\\]"] :> 
               ToLowerCase["$1"] <> "$2"]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "\\[Sigma]" -> "sigma", "\\[Alpha]" -> "alpha", "\\[Beta]" -> 
                "beta", "\\[Gamma]" -> "gamma", "\\[Delta]" -> "delta", 
                "\\[Epsilon]" -> "epsilon", "\\[Lambda]" -> "lambda", 
                "\\[Mu]" -> "mu", "\\[Pi]" -> "pi", "\\[Theta]" -> "theta", 
                "\\[Phi]" -> "phi", "\\[Omega]" -> "omega"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "\[Sigma]" -> "sigma", "\[Alpha]" -> "alpha", "\[Beta]" -> 
                "beta", "\[Gamma]" -> "gamma", "\[Delta]" -> "delta", 
                "\[CurlyEpsilon]" -> "epsilon", "\[Lambda]" -> "lambda", 
                "\[Mu]" -> "mu", "\[Pi]" -> "pi", "\[Theta]" -> "theta", 
                "\[CurlyPhi]" -> "phi", "\[Omega]" -> "omega"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "[" -> "", "]" -> "", "," -> "", "\\" -> "", "{" -> "", "}" -> 
                "", "$" -> "", "&" -> "", "%" -> "", "#" -> "", "^" -> "", 
                "_" -> "", "~" -> "", " " -> "", "\"" -> ""}]; If[
              Not[
               StringMatchQ[VilTeX`Private`cleanName, 
                RegularExpression["^[a-zA-Z].*"]]], VilTeX`Private`cleanName = 
              "state" <> VilTeX`Private`cleanName, VilTeX`Private`cleanName = 
              "state" <> VilTeX`Private`cleanName]; VilTeX`Private`cleanName]; 
         VilTeX`Private`getStateLabel[
            Pattern[VilTeX`Private`state, 
             Blank[]]] := 
          Module[{VilTeX`Private`label, VilTeX`Private`stateStr}, 
            If[
            VilTeX`Private`showLabels, 
             VilTeX`Private`stateStr = 
              ToString[VilTeX`Private`state, InputForm]; If[
               MatchQ[VilTeX`Private`state, 
                Subscript[
                 Blank[], 
                 Blank[]]], 
               
               Module[{VilTeX`Private`base, VilTeX`Private`index}, 
                VilTeX`Private`base = Part[VilTeX`Private`state, 1]; 
                VilTeX`Private`index = Part[VilTeX`Private`state, 2]; 
                VilTeX`Private`label = Which[
                   Or[
                   ToString[VilTeX`Private`base] === "\[Sigma]", 
                    ToString[VilTeX`Private`base] === "\\[Sigma]"], 
                   "\\sigma_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Alpha]", 
                    ToString[VilTeX`Private`base] === "\\[Alpha]"], 
                   "\\alpha_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Beta]", 
                    ToString[VilTeX`Private`base] === "\\[Beta]"], "\\beta_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Gamma]", 
                    ToString[VilTeX`Private`base] === "\\[Gamma]"], 
                   "\\gamma_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Delta]", 
                    ToString[VilTeX`Private`base] === "\\[Delta]"], 
                   "\\delta_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[CurlyEpsilon]", 
                    ToString[VilTeX`Private`base] === "\\[Epsilon]"], 
                   "\\varepsilon_{" <> ToString[VilTeX`Private`index] <> "}", 
                   
                   Or[
                   ToString[VilTeX`Private`base] === "\[Lambda]", 
                    ToString[VilTeX`Private`base] === "\\[Lambda]"], 
                   "\\lambda_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Mu]", 
                    ToString[VilTeX`Private`base] === "\\[Mu]"], "\\mu_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Pi]", 
                    ToString[VilTeX`Private`base] === "\\[Pi]"], "\\pi_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Theta]", 
                    ToString[VilTeX`Private`base] === "\\[Theta]"], 
                   "\\theta_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[CurlyPhi]", 
                    ToString[VilTeX`Private`base] === "\\[Phi]"], "\\phi_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Omega]", 
                    ToString[VilTeX`Private`base] === "\\[Omega]"], 
                   "\\omega_{" <> ToString[VilTeX`Private`index] <> "}", True,
                    ToString[VilTeX`Private`base] <> "_{" <> 
                   ToString[VilTeX`Private`index] <> "}"]; Null], 
               If[
                StringContainsQ[VilTeX`Private`stateStr, "Subscript"], 
                VilTeX`Private`label = 
                 StringReplace[
                  VilTeX`Private`stateStr, {
                   "Subscript[\\[Sigma], 0]" -> "\\sigma_0", 
                    "Subscript[\\[Sigma], 1]" -> "\\sigma_1", 
                    "Subscript[\\[Sigma], 2]" -> "\\sigma_2", 
                    "Subscript[\\[Sigma], 3]" -> "\\sigma_3", 
                    "Subscript[\\[Sigma], 4]" -> "\\sigma_4", 
                    "Subscript[\\[Sigma], 5]" -> "\\sigma_5", 
                    "Subscript[\[Sigma], 0]" -> "\\sigma_0", 
                    "Subscript[\[Sigma], 1]" -> "\\sigma_1", 
                    "Subscript[\[Sigma], 2]" -> "\\sigma_2", 
                    "Subscript[\[Sigma], 3]" -> "\\sigma_3", 
                    "Subscript[\[Sigma], 4]" -> "\\sigma_4", 
                    "Subscript[\[Sigma], 5]" -> "\\sigma_5", 
                    "Subscript[\\[Alpha], 0]" -> "\\alpha_0", 
                    "Subscript[\\[Alpha], 1]" -> "\\alpha_1", 
                    "Subscript[\\[Beta], 0]" -> "\\beta_0", 
                    "Subscript[\\[Beta], 1]" -> "\\beta_1", 
                    "Subscript[\\[Gamma], 0]" -> "\\gamma_0", 
                    "Subscript[\\[Gamma], 1]" -> "\\gamma_1"}]; Null, 
                VilTeX`Private`label = StringReplace[
                   ToString[VilTeX`Private`state], {
                   "\[Sigma]" -> "\\sigma", "\[Alpha]" -> "\\alpha", 
                    "\[Beta]" -> "\\beta", "\[Gamma]" -> "\\gamma", 
                    "\[Delta]" -> "\\delta", "\[CurlyEpsilon]" -> 
                    "\\varepsilon", "\[Lambda]" -> "\\lambda", "\[Mu]" -> 
                    "\\mu", "\[Pi]" -> "\\pi", "\[Theta]" -> "\\theta", 
                    "\[CurlyPhi]" -> "\\phi", "\[Omega]" -> "\\omega", 
                    "\\[Sigma]" -> "\\sigma", "\\[Alpha]" -> "\\alpha", 
                    "\\[Beta]" -> "\\beta", "\\[Gamma]" -> "\\gamma", 
                    "\\[Delta]" -> "\\delta", "\\[Epsilon]" -> "\\varepsilon",
                     "\\[Lambda]" -> "\\lambda", "\\[Mu]" -> "\\mu", "\\[Pi]" -> 
                    "\\pi", "\\[Theta]" -> "\\theta", "\\[Phi]" -> "\\phi", 
                    "\\[Omega]" -> "\\omega"}]; Null]]; VilTeX`Private`label, 
             ""]]; VilTeX`Private`numStates = Length[VilTeX`Private`states]; 
         If[VilTeX`Private`automaticLayout, 
           Switch[
           VilTeX`Private`layoutStyle, "circular", 
            VilTeX`Private`statePositions = <|
              Table[
              Part[VilTeX`Private`states, VilTeX`Private`i] -> {
                VilTeX`Private`nodeDistance 
                 Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                 VilTeX`Private`nodeDistance 
                 Sin[2 Pi ((VilTeX`Private`i - 1)/
                    VilTeX`Private`numStates)]}, {
               VilTeX`Private`i, VilTeX`Private`numStates}]|>, "grid", 
            VilTeX`Private`gridCols = Ceiling[
               Sqrt[VilTeX`Private`numStates]]; 
            VilTeX`Private`gridRows = 
             Ceiling[VilTeX`Private`numStates/VilTeX`Private`gridCols]; 
            VilTeX`Private`statePositions = <|
               Table[
                
                Module[{
                 VilTeX`Private`row = 
                  Ceiling[VilTeX`Private`i/VilTeX`Private`gridCols], 
                  VilTeX`Private`col = 
                  Mod[VilTeX`Private`i - 1, VilTeX`Private`gridCols] + 1}, 
                 Part[VilTeX`Private`states, 
                   VilTeX`Private`i] -> {(VilTeX`Private`col - 1) 
                    VilTeX`Private`nodeDistance - (VilTeX`Private`gridCols - 
                    1) (VilTeX`Private`nodeDistance/
                    2), (VilTeX`Private`gridRows - VilTeX`Private`row) 
                    VilTeX`Private`nodeDistance - (VilTeX`Private`gridRows - 
                    1) (VilTeX`Private`nodeDistance/2)}], {
                VilTeX`Private`i, VilTeX`Private`numStates}]|>, "spring", 
            
            Module[{VilTeX`Private`positions = 
              RandomReal[{-VilTeX`Private`nodeDistance, 
                 VilTeX`Private`nodeDistance}, {
                VilTeX`Private`numStates, 2}]}, 
             VilTeX`Private`statePositions = <|
               Thread[VilTeX`Private`states -> VilTeX`Private`positions]|>], 
            Blank[], VilTeX`Private`statePositions = <|
              Table[
              Part[VilTeX`Private`states, VilTeX`Private`i] -> {
                VilTeX`Private`nodeDistance 
                 Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                 VilTeX`Private`nodeDistance 
                 Sin[2 Pi ((VilTeX`Private`i - 1)/
                    VilTeX`Private`numStates)]}, {
               VilTeX`Private`i, VilTeX`Private`numStates}]|>], 
           VilTeX`Private`statePositions = <|
             Table[
             Part[VilTeX`Private`states, VilTeX`Private`i] -> {
               VilTeX`Private`nodeDistance 
                Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                VilTeX`Private`nodeDistance 
                Sin[2 Pi ((VilTeX`Private`i - 1)/
                   VilTeX`Private`numStates)]}, {
              VilTeX`Private`i, VilTeX`Private`numStates}]|>]; 
         VilTeX`Private`transitionMap = <||>; VilTeX`Private`selfLoops = {}; 
         Do[
           
           Module[{VilTeX`Private`origin, VilTeX`Private`symbol, 
             VilTeX`Private`destinations}, {
              VilTeX`Private`origin, VilTeX`Private`symbol, 
               VilTeX`Private`destinations} = 
             Part[VilTeX`Private`transitions, VilTeX`Private`i]; 
            Module[{VilTeX`Private`destList}, VilTeX`Private`destList = If[
                 ListQ[VilTeX`Private`destinations], 
                 VilTeX`Private`destinations, {VilTeX`Private`destinations}]; 
              Do[
                
                Module[{
                 VilTeX`Private`dest = 
                  Part[VilTeX`Private`destList, VilTeX`Private`j], 
                  VilTeX`Private`key}, 
                 If[VilTeX`Private`origin === VilTeX`Private`dest, 
                  AppendTo[
                  VilTeX`Private`selfLoops, {
                   VilTeX`Private`origin, VilTeX`Private`symbol}], 
                  VilTeX`Private`key = {
                    VilTeX`Private`origin, VilTeX`Private`dest}; If[
                    KeyExistsQ[
                    VilTeX`Private`transitionMap, VilTeX`Private`key], 
                    VilTeX`Private`transitionMap[VilTeX`Private`key] = 
                    Append[
                    VilTeX`Private`transitionMap[VilTeX`Private`key], 
                    VilTeX`Private`symbol], 
                    VilTeX`Private`transitionMap[VilTeX`Private`key] = {
                    VilTeX`Private`symbol}]]], {VilTeX`Private`j, 
                 Length[VilTeX`Private`destList]}]]], {VilTeX`Private`i, 
            Length[VilTeX`Private`transitions]}]; 
         Module[{VilTeX`Private`selfLoopGroups = 
            GroupBy[VilTeX`Private`selfLoops, First -> Last]}, 
           VilTeX`Private`selfLoops = 
           KeyValueMap[{#, #2}& , VilTeX`Private`selfLoopGroups]]; 
         VilTeX`Private`tikzCode = "\\begin{tikzpicture}[\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  -stealth,\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "  shorten >=1pt,\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  auto,\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "  node distance=" <> 
           ToString[VilTeX`Private`nodeDistance] <> "cm,\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  semithick\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "]\n\n"; 
         If[VilTeX`Private`showGrid, 
           
           Module[{VilTeX`Private`minX, VilTeX`Private`maxX, 
             VilTeX`Private`minY, VilTeX`Private`maxY, 
             VilTeX`Private`gridRange}, {
              VilTeX`Private`minX, VilTeX`Private`maxX} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 1]]; {
              VilTeX`Private`minY, VilTeX`Private`maxY} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 2]]; 
            VilTeX`Private`gridRange = Max[
                Abs[VilTeX`Private`minX], 
                Abs[VilTeX`Private`maxX], 
                Abs[VilTeX`Private`minY], 
                Abs[VilTeX`Private`maxY]] + 1.5; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "% Rejilla de fondo\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> 
              "\\draw[help lines, step=0.5cm, color=gray!20] " <> "(-" <> 
              ToString[VilTeX`Private`gridRange] <> ",-" <> 
              ToString[VilTeX`Private`gridRange] <> ") grid (" <> 
              ToString[VilTeX`Private`gridRange] <> "," <> 
              ToString[VilTeX`Private`gridRange] <> ");\n\n"; Null]]; 
         If[VilTeX`Private`showAxes, 
           
           Module[{VilTeX`Private`minX, VilTeX`Private`maxX, 
             VilTeX`Private`minY, VilTeX`Private`maxY, VilTeX`Private`xRange, 
             VilTeX`Private`yRange}, {
              VilTeX`Private`minX, VilTeX`Private`maxX} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 1]]; {
              VilTeX`Private`minY, VilTeX`Private`maxY} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 2]]; 
            VilTeX`Private`xRange = Max[
                Abs[VilTeX`Private`minX], 
                Abs[VilTeX`Private`maxX]] + 1.5; VilTeX`Private`yRange = Max[
                Abs[VilTeX`Private`minY], 
                Abs[VilTeX`Private`maxY]] + 1.5; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "% Ejes de coordenadas\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\draw[thick, ->, color=black] (-" <> 
              ToString[VilTeX`Private`xRange] <> ",0) -- (" <> 
              ToString[VilTeX`Private`xRange] <> ",0) node[right] {$x$};\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\draw[thick, ->, color=black] (0,-" <> 
              ToString[VilTeX`Private`yRange] <> ") -- (0," <> 
              ToString[VilTeX`Private`yRange] <> ") node[above] {$y$};\n\n"; 
            Null]]; VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "% Definir estilos\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> 
           "\\tikzstyle{state}=[circle, draw, minimum size=" <> 
           ToString[VilTeX`Private`stateSize] <> "cm, fill=" <> 
           VilTeX`Private`stateColor <> "]\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> 
           "\\tikzstyle{accepting}=[circle, draw, minimum size=" <> 
           ToString[VilTeX`Private`stateSize] <> "cm, fill=" <> 
           VilTeX`Private`stateColor <> ", double]\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> 
           "\\tikzstyle{initial}=[circle, draw, minimum size=" <> 
           ToString[VilTeX`Private`stateSize] <> "cm, fill=" <> 
           VilTeX`Private`stateColor <> "]\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> 
           "\\tikzstyle{initial accepting}=[circle, draw, minimum size=" <> 
           ToString[VilTeX`Private`stateSize] <> "cm, fill=" <> 
           VilTeX`Private`stateColor <> ", double]\n\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "% Estados\n"; 
         Do[
           
           Module[{VilTeX`Private`state = 
             Part[VilTeX`Private`states, VilTeX`Private`i], 
             VilTeX`Private`pos, VilTeX`Private`stateStyle, 
             VilTeX`Private`stateLabel, VilTeX`Private`nodeName, 
             VilTeX`Private`currentStateColor}, 
            VilTeX`Private`pos = 
             VilTeX`Private`statePositions[VilTeX`Private`state]; 
            VilTeX`Private`nodeName = 
             VilTeX`Private`cleanNodeName[VilTeX`Private`state]; 
            VilTeX`Private`stateLabel = 
             VilTeX`Private`getStateLabel[VilTeX`Private`state]; 
            VilTeX`Private`currentStateColor = If[
               And[VilTeX`Private`autoColor, 
                KeyExistsQ[
                VilTeX`Private`stateColorMap, VilTeX`Private`state]], 
               VilTeX`Private`stateColorMap[VilTeX`Private`state], 
               VilTeX`Private`stateColor]; VilTeX`Private`stateStyle = Which[
               And[VilTeX`Private`state === VilTeX`Private`initialState, 
                MemberQ[
                VilTeX`Private`acceptingStates, VilTeX`Private`state]], 
               "initial accepting", VilTeX`Private`state === 
               VilTeX`Private`initialState, "initial", 
               MemberQ[VilTeX`Private`acceptingStates, VilTeX`Private`state], 
               "accepting", True, "state"]; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\node[" <> 
              VilTeX`Private`stateStyle <> ", fill=" <> 
              VilTeX`Private`currentStateColor <> "] (" <> 
              VilTeX`Private`nodeName <> ") at (" <> 
              VilTeX`Private`formatNum[
                Part[VilTeX`Private`pos, 1]] <> "," <> 
              VilTeX`Private`formatNum[
                Part[VilTeX`Private`pos, 2]] <> ") {"; If[
              And[VilTeX`Private`showLabels, VilTeX`Private`stateLabel != ""],
               VilTeX`Private`tikzCode = 
              VilTeX`Private`tikzCode <> "$" <> VilTeX`Private`stateLabel <> 
               "$"]; VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "};\n"; Null], {VilTeX`Private`i, 
            Length[VilTeX`Private`states]}]; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "\n"; 
         Module[{VilTeX`Private`initialPos = 
            VilTeX`Private`statePositions[VilTeX`Private`initialState], 
            VilTeX`Private`startPos, VilTeX`Private`initialNodeName, 
            VilTeX`Private`thicknessStyle}, 
           VilTeX`Private`initialNodeName = 
            VilTeX`Private`cleanNodeName[VilTeX`Private`initialState]; 
           VilTeX`Private`startPos = {
             Part[VilTeX`Private`initialPos, 1] - 1.5, 
              Part[VilTeX`Private`initialPos, 2]}; 
           VilTeX`Private`thicknessStyle = 
            If[VilTeX`Private`arrowThickness === True, "ultra thick, ", ""]; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Flecha inicial\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "\\draw[" <> 
             VilTeX`Private`thicknessStyle <> "-stealth] (" <> 
             VilTeX`Private`formatNum[
               Part[VilTeX`Private`startPos, 1]] <> "," <> 
             VilTeX`Private`formatNum[
               Part[VilTeX`Private`startPos, 2]] <> ") -- (" <> 
             VilTeX`Private`initialNodeName <> ");\n\n"; Null]; 
         If[Length[VilTeX`Private`selfLoops] > 0, 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Self-loops\n"; Do[
             
             Module[{VilTeX`Private`state, VilTeX`Private`symbols, 
               VilTeX`Private`symbolStr, VilTeX`Private`loopDirection, 
               VilTeX`Private`nodeName, 
               VilTeX`Private`edgeColor}, {
                VilTeX`Private`state, VilTeX`Private`symbols} = 
               Part[VilTeX`Private`selfLoops, VilTeX`Private`i]; 
              VilTeX`Private`nodeName = 
               VilTeX`Private`cleanNodeName[VilTeX`Private`state]; 
              VilTeX`Private`edgeColor = If[
                 And[VilTeX`Private`autoColor, 
                  KeyExistsQ[
                  VilTeX`Private`stateColorMap, VilTeX`Private`state]], 
                 VilTeX`Private`stateColorMap[VilTeX`Private`state], 
                 VilTeX`Private`transitionColor]; 
              VilTeX`Private`symbolStr = StringRiffle[
                 Map[
                 VilTeX`Private`convertSymbolToLaTeX, VilTeX`Private`symbols],
                  ","]; VilTeX`Private`loopDirection = Switch[
                 Mod[VilTeX`Private`i - 1, 4], 0, "loop above", 1, 
                 "loop right", 2, "loop below", 3, "loop left"]; 
              VilTeX`Private`tikzCode = 
               VilTeX`Private`tikzCode <> "\\path (" <> 
                VilTeX`Private`nodeName <> ") edge [" <> 
                VilTeX`Private`loopDirection <> ", " <> 
                VilTeX`Private`edgeColor <> "] node {$" <> 
                VilTeX`Private`symbolStr <> "$} (" <> VilTeX`Private`nodeName <> 
                ");\n"; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`selfLoops]}]; 
           VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "\n"; Null]; 
         If[Length[VilTeX`Private`transitionMap] > 0, 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Transiciones\n"; 
           Module[{VilTeX`Private`keyList = 
              Keys[VilTeX`Private`transitionMap], 
              VilTeX`Private`processedPairs = {}}, 
             Do[
              
              Module[{VilTeX`Private`key, VilTeX`Private`symbols, 
                VilTeX`Private`origin, VilTeX`Private`dest, 
                VilTeX`Private`symbolStr, VilTeX`Private`reversePair, 
                VilTeX`Private`bidirectional, VilTeX`Private`curveAngle, 
                VilTeX`Private`isFirstOfPair, VilTeX`Private`originNodeName, 
                VilTeX`Private`destNodeName, VilTeX`Private`originEdgeColor}, 
               VilTeX`Private`key = 
                Part[VilTeX`Private`keyList, VilTeX`Private`i]; 
               VilTeX`Private`symbols = 
                VilTeX`Private`transitionMap[VilTeX`Private`key]; {
                 VilTeX`Private`origin, VilTeX`Private`dest} = 
                VilTeX`Private`key; 
               VilTeX`Private`originNodeName = 
                VilTeX`Private`cleanNodeName[VilTeX`Private`origin]; 
               VilTeX`Private`destNodeName = 
                VilTeX`Private`cleanNodeName[VilTeX`Private`dest]; 
               VilTeX`Private`originEdgeColor = If[
                  And[VilTeX`Private`autoColor, 
                   KeyExistsQ[
                   VilTeX`Private`stateColorMap, VilTeX`Private`origin]], 
                  VilTeX`Private`stateColorMap[VilTeX`Private`origin], 
                  VilTeX`Private`transitionColor]; 
               VilTeX`Private`symbolStr = StringRiffle[
                  Map[
                  VilTeX`Private`convertSymbolToLaTeX, 
                   VilTeX`Private`symbols], ","]; 
               VilTeX`Private`reversePair = {
                 VilTeX`Private`dest, VilTeX`Private`origin}; 
               VilTeX`Private`bidirectional = 
                KeyExistsQ[
                 VilTeX`Private`transitionMap, VilTeX`Private`reversePair]; 
               VilTeX`Private`isFirstOfPair = And[
                  Not[
                   MemberQ[
                   VilTeX`Private`processedPairs, {
                    VilTeX`Private`key, VilTeX`Private`reversePair}]], 
                  Not[
                   MemberQ[
                   VilTeX`Private`processedPairs, {
                    VilTeX`Private`reversePair, VilTeX`Private`key}]]]; If[
                 Or[
                  Not[VilTeX`Private`bidirectional], 
                  VilTeX`Private`isFirstOfPair], 
                 
                 Module[{
                  VilTeX`Private`originPos, VilTeX`Private`destPos, 
                   VilTeX`Private`dx, VilTeX`Private`dy, VilTeX`Private`angle,
                    VilTeX`Private`baseAngle = 20}, 
                  VilTeX`Private`originPos = 
                   VilTeX`Private`statePositions[VilTeX`Private`origin]; 
                  VilTeX`Private`destPos = 
                   VilTeX`Private`statePositions[VilTeX`Private`dest]; 
                  VilTeX`Private`dx = 
                   Part[VilTeX`Private`destPos, 1] - Part[
                    VilTeX`Private`originPos, 1]; 
                  VilTeX`Private`dy = 
                   Part[VilTeX`Private`destPos, 2] - Part[
                    VilTeX`Private`originPos, 2]; 
                  VilTeX`Private`angle = 
                   If[VilTeX`Private`bidirectional, VilTeX`Private`baseAngle, 
                    VilTeX`Private`baseAngle/2]; 
                  If[Abs[VilTeX`Private`dx] < 0.5, VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy > 0, VilTeX`Private`angle, -
                    VilTeX`Private`angle], 
                    If[
                    VilTeX`Private`dx > 0, VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy >= 0, VilTeX`Private`angle, -
                    VilTeX`Private`angle], VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy >= 0, -VilTeX`Private`angle, 
                    VilTeX`Private`angle]]]; 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> "\\path (" <> 
                    VilTeX`Private`originNodeName <> ") edge [bend left=" <> 
                    ToString[
                    Abs[VilTeX`Private`curveAngle]] <> ", " <> 
                    VilTeX`Private`originEdgeColor <> "] node [above] {$" <> 
                    VilTeX`Private`symbolStr <> "$} (" <> 
                    VilTeX`Private`destNodeName <> ");\n"; 
                  If[VilTeX`Private`bidirectional, 
                    Module[{
                    VilTeX`Private`reverseSymbols, 
                    VilTeX`Private`reverseSymbolStr, 
                    VilTeX`Private`destEdgeColor}, 
                    VilTeX`Private`reverseSymbols = 
                    VilTeX`Private`transitionMap[VilTeX`Private`reversePair]; 
                    VilTeX`Private`reverseSymbolStr = StringRiffle[
                    Map[
                    VilTeX`Private`convertSymbolToLaTeX, 
                    VilTeX`Private`reverseSymbols], ","]; 
                    VilTeX`Private`destEdgeColor = If[
                    And[VilTeX`Private`autoColor, 
                    KeyExistsQ[
                    VilTeX`Private`stateColorMap, VilTeX`Private`dest]], 
                    VilTeX`Private`stateColorMap[VilTeX`Private`dest], 
                    VilTeX`Private`transitionColor]; 
                    VilTeX`Private`tikzCode = 
                    VilTeX`Private`tikzCode <> "\\path (" <> 
                    VilTeX`Private`destNodeName <> ") edge [bend left=" <> 
                    ToString[
                    Abs[VilTeX`Private`curveAngle]] <> ", " <> 
                    VilTeX`Private`destEdgeColor <> "] node [below] {$" <> 
                    VilTeX`Private`reverseSymbolStr <> "$} (" <> 
                    VilTeX`Private`originNodeName <> ");\n"; Null]; 
                    AppendTo[
                    VilTeX`Private`processedPairs, {
                    VilTeX`Private`key, VilTeX`Private`reversePair}]; 
                    Null]]]], {VilTeX`Private`i, 
               Length[VilTeX`Private`keyList]}]]; Null]; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n" <> "\\usepackage[dvipsnames]{xcolor}\n" <> 
           "\\usetikzlibrary{automata, positioning, arrows}\n" <> 
           "\\usepackage{amsmath}\n" <> "\\usepackage{amssymb}\n" <> 
           "\n% Colores personalizados adicionales\n" <> 
           "\\definecolor{lightblue}{RGB}{173,216,230}\n" <> 
           "\\definecolor{lightgreen}{RGB}{144,238,144}\n" <> 
           "\\definecolor{lightyellow}{RGB}{255,255,224}\n" <> 
           "\\definecolor{lightgray}{RGB}{211,211,211}\n" <> 
           "\\definecolor{darkgray}{RGB}{169,169,169}\n" <> 
           "\\definecolor{orange}{RGB}{255,165,0}\n" <> 
           "\\definecolor{purple}{RGB}{128,0,128}\n" <> 
           "\\definecolor{pink}{RGB}{255,192,203}\n" <> 
           "\n\\begin{document}\n" <> VilTeX`Private`tikzCode <> 
           "\n\\end{document}"; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportAutomataToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.967274644658184*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"05c77937-562e-4d17-aa77-87ba2819340d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1", "Subsection",
 CellChangeTimes->{{3.967116565490749*^9, 
  3.967116569632372*^9}},ExpressionUUID->"fda263c4-2be5-4d9f-9165-\
de0be1e4d9b5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataDRandom", "[", 
  RowBox[{"3", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aut1", "=", 
   RowBox[{"ComponentesAutomata", "[", 
    RowBox[{"G", ",", 
     RowBox[{"conjuntos", "->", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportAutomataToTikZ", "[", 
   RowBox[{
    RowBox[{"aut1", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"aut1", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"aut1", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"aut1", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"aut1", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<aut1.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "0.8"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "4"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", "\"\<lightblue\>\""}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", "\"\<grid\>\""}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", "\"\<purple\>\""}], ",", 
    RowBox[{"\"\<ShowGrid\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "False"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.967116635105261*^9, {3.967117018513253*^9, 3.9671170300476837`*^9}, 
   3.967117123108487*^9, 3.967117264712372*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"305a6fd9-80d3-46f9-8bd2-7a76a7b964fa"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.2598076211353315], 
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.17320508075688767], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {-0.5000000000000002, 0.8660254037844386}],
    PolygonBox[{{-0.43613034271187856`, -0.5172320364740529}, \
{-0.43275683958739564`, -0.6150705126630965}, {-0.3497129853023664, \
-0.5632297351630263}}], 
   CircleBox[{-1.4980902177573159`, -1.1102230246251565`*^-16}, 
    1.2301410253261933, {5.759486531581288, 6.806784082777885}], 
   InsetBox["\<\"b\"\>", {-0.2679491939687988, -0.0000615070512409507}, 
    NCache[ImageScaled[{1, Rational[1, 2]}], ImageScaled[{1, 0.5}]]], 
   PolygonBox[{{0.7297425874822167, 0.2297699038340369}, {0.8162882692912617, 
    0.1837117307087383}, {0.8129029763651495, 0.28169157630586544`}}], 
   CircleBox[{-0.2490267386241761, -0.4313771540459576}, 1.2301343025209261, {
    0.5236191764807366, 1.5708167276773342`}], 
   InsetBox["\<\"c\"\>", {0.36601867888606554, 0.633962949694767}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.8606189032885296, 0.9135017830796011}, 0.12990381056766576, {
    0.3926990816987246, 5.6286868376817125`}], 
   PolygonBox[{{-0.8514965746941557, 
    0.9929275473473261}, {-0.7406034315098399, 
    0.9632138191849399}, {-0.7703171596722261, 1.0741069623692558`}}], 
   InsetBox["\<\"a\"\>", {-0.8436630535402574, 1.0422942485397901}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{-0.4999999999999996, -0.8660254037844388}, 0.2598076211353315], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "1"], {-0.4999999999999996, -0.8660254037844388}], 
   PolygonBox[{{0.662500134477933, -0.02118308761495776}, {
    0.7490451088786577, -0.067243160412604}, {
    0.6658834285353731, -0.11916327041468247`}}], 
   CircleBox[{0.749045108878658, -1.2973841857387967`}, 1.2301410253261928, {
    1.5707963267948966`, 2.6179938779914944`}], 
   InsetBox["\<\"c\"\>", {0.1339745962155614, -0.2320508075688772}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.6504048407558883, 
    0.5631504026610177}, {-0.5672431604126041, 
    0.6150705126630963}, {-0.5638598663551636, 0.5170903298633718}}], 
   CircleBox[{0.4980902177573161, -1.1102230246251565`*^-16}, 
    1.2301410253261933, {2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"b\"\>", {-0.7320508075688772, 3.962652445404093*^-17}, 
    NCache[ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]], 
   CircleBox[{-0.6818653347947317, -1.1810254037844388`}, 
    0.12990381056766576, {-4.71238898038469, 0.5235987755982991}], 
   PolygonBox[{{-0.7956881915601098, -1.0361365298410785`}, \
{-0.6818653347947317, -1.051121593216773}, {-0.7517542087380918, \
-1.1422025470190609`}}], 
   InsetBox["\<\"a\"\>", {-0.7943653347947316, -1.116073498500606}, 
    ImageScaled[{1, 0}]], CircleBox[{1., 0}, 0.2598076211353315], InsetBox[
    SubscriptBox["\[Sigma]", "2"], {1., 0}], 
   PolygonBox[{{-0.33559008327938267`, -0.8448423161694814}, \
{-0.24904510887865733`, -0.7987822433718348}, {-0.3322067892219426, \
-0.746862133369756}}], 
   CircleBox[{-0.2490451088786576, 0.4313587819543578}, 1.2301410253261928, {
    5.759486531581287, 4.71238898038469}], 
   InsetBox["\<\"b\"\>", {0.36597213634671366, -0.6340053484095158}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.3637306695894642`, 0.}, 
    0.12990381056766576, {-2.617993877991494, 2.6179938779914944`}], 
   PolygonBox[{{1.2951646524114822`, -0.17101792246181505`}, {
    1.2512306695894642`, -0.06495190528383292}, {
    1.3650535263548422`, -0.07993696865952729}}], 
   InsetBox["\<\"c,a\"\>", {1.3637306695894642, -0.12990381056766576}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-0.5000000000000002, 1.3856406460551016`}, {-0.5000000000000002,
      1.12583302491977}}], 
    PolygonBox[{{-0.5000000000000002, 1.12583302491977}, {-0.5866025403784441,
      1.2557368354874359`}, {-0.4133974596215564, 1.2557368354874359`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{3.9671172671899557`*^9, 3.967118426353891*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"0bb8f63d-1491-4dff-a224-191aca4c5da6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.9671184263651123`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"d71c19aa-4b34-4049-967f-3d3c56b7497e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.9671184263660088`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"f67a73f6-0554-44bd-881b-a2e4406fbe17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.96711842636646*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"56ab22bd-f99c-45c5-9061-0f18066ff24b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118426366775*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"d707ab3b-e4e2-45c0-a506-e038ccaa9d51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.9671184263670883`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"115b17af-db7f-442b-9430-6030ecf4621e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118426593458*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"52fd7084-b6c9-4e3f-a47a-2054b4088253"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118427599112*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"a6c3c3ba-2f20-46ae-8b2f-3abad7d47821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/aut1/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118427601276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"8f8bdc29-7f0a-458e-bc7d-0cdf283e9358"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"aut1\"\>"}],
  SequenceForm["Archivo: ", "aut1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118427602529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"870e01cd-9b8f-4c1a-b795-b799edc0275f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.9671184281709146`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"7ab66d29-9ebf-4161-9896-10dc2218aef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut1/aut1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/aut1/aut1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96711726719349*^9, 3.967118428171473*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"b9032cb2-6038-4bc6-a867-3151d1ba9ef0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/aut1/aut1.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.9671172671899557`*^9, 3.967118428182823*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"30e31dbb-9373-44b8-8d9e-f09bc94d4384"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2", "Subsection",
 CellChangeTimes->{{3.967116565490749*^9, 
  3.967116582185677*^9}},ExpressionUUID->"d725bf0f-39ed-4f50-a9b6-\
14f29f747bfe"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataDRandom", "[", 
  RowBox[{"4", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aut2", "=", 
   RowBox[{"ComponentesAutomata", "[", 
    RowBox[{"G", ",", 
     RowBox[{"conjuntos", "->", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportAutomataToTikZ", "[", 
   RowBox[{
    RowBox[{"aut2", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"aut2", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"aut2", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"aut2", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"aut2", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<aut2.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "1"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "5"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", "\"\<Turquoise\>\""}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", "\"\<spring\>\""}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", "\"\<Salmon\>\""}], ",", 
    RowBox[{"\"\<ShowGrid\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9671166250458727`*^9, {3.967117051434784*^9, 3.967117062840678*^9}, 
   3.967117120948098*^9, 3.967117298088491*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"7efc7bcd-cd0e-4958-a913-1cefa51f1749"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, -1.}, 0.21213203435596426], 
   CircleBox[{0, -1.}, 0.1414213562373095], InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0, -1.}], 
   PolygonBox[{{-0.1407232001028063, 
    0.7423580748420086}, {-0.054903810567665766`, 
    0.7950961894323342}, {-0.0521409583523193, 0.6944053606624673}}], 
   CircleBox[{1.3222431864335462`, 0.}, 1.5901923788646692, {
    2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"c\"\>", {-0.26794919243112303, 1.9474240068051325*^-16}, 
    NCache[ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]], 
   PolygonBox[{{-0.9119881492573625, -0.26171242394603667`}, \
{-0.8939523545253881, -0.1837223363918798}, {-0.8354288548261029, \
-0.2383368365842895}}], 
   CircleBox[{0.07622928525500816, 0.07625826341797694}, 1.0044114328523306, {
    3.40341244150172, 4.450609992698317}], 
   InsetBox["\<\"b\"\>", {-0.6339823611751302, -0.633982360398673}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.818507718094536*^-17, -1.29698484809835}, 
    0.10606601717798213, {-4.1887902047863905`, 1.0471975511965983`}], 
   PolygonBox[{{-0.13963554896743488`, -1.2410009295046958`}, \
{-0.05303300858899109, -1.2051289827439808`}, {-0.06526826160023091, \
-1.2980649561243383`}}], 
   InsetBox["\<\"a\"\>", {-0.10606601717798211, -1.29698484809835}, 
    ImageScaled[{1, 1}]], CircleBox[{1., 0}, 0.21213203435596426], 
   CircleBox[{1., 0}, 0.1414213562373095], InsetBox[
    SubscriptBox["\[Sigma]", "1"], {1., 0}], 
   PolygonBox[{{-0.7423580748420082, -0.1407232001028068}, \
{-0.7950961894323342, -0.054903810567665794`}, {-0.6944053606624667, \
-0.052140958352319244`}}], 
   CircleBox[{0., 1.3222431864335462`}, 1.5901923788646692, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"b\"\>", {-0.00007950961891021128, -0.2679491904433826}, 
    NCache[ImageScaled[{Rational[1, 2], 0}], ImageScaled[{0.5, 0}]]], 
   PolygonBox[{{0.23825110833655275`, -0.8354992193201393}, {
    0.18371173070873834`, -0.8939339828220179}, {
    0.26158740917940815`, -0.9119490876033586}}], 
   CircleBox[{-0.07624765589771844, 0.0762476558977182}, 1.0044059412377637, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"c\"\>", {0.6339035704393572, -0.6340456148895433}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.29698484809835, 0.}, 0.10606601717798213, {-2.617993877991494,
     2.6179938779914944`}], 
   PolygonBox[{{1.2410009295046958`, -0.1396355489674349}, {
    1.2051289827439808`, -0.0530330085889911}, {
    1.2980649561243383`, -0.06526826160023091}}], 
   InsetBox["\<\"a\"\>", {1.29698484809835, -0.10606601717798213}, 
    ImageScaled[{0, 1}]], CircleBox[{0, 1.}, 0.21213203435596426], 
   CircleBox[{0, 1.}, 0.1414213562373095], InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0, 1.}], 
   PolygonBox[{{0.05215101826801368, -0.6945887044799934}, {
    0.054903810567665794`, -0.7950961894323342}, {
    0.140569449657049, -0.742458458893323}}], 
   CircleBox[{-1.3222431864335462`, 0.}, 1.5901923788646692, {
    5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"c,a\"\>", {0.2679491904433826, -0.00007950961891030864}, 
    NCache[ImageScaled[{1, Rational[1, 2]}], ImageScaled[{1, 0.5}]]], 
   PolygonBox[{{0.8354107928091821, 0.23832592115722095`}, {
    0.8939339828220179, 0.18371173070873836`}, {0.9119696641511073, 
    0.26170139519459923`}}], 
   CircleBox[{-0.076237050214577, -0.07626602760108876}, 1.0044004520902492, {
    0.2618197886815869, 1.3090173398781844`}], 
   InsetBox["\<\"b\"\>", {0.6339668312559927, 0.6339668320324499}, 
    ImageScaled[{1, 1}]], CircleBox[{-1., 0}, 0.21213203435596426], 
   CircleBox[{-1., 0}, 0.1414213562373095], InsetBox[
    SubscriptBox["\[Sigma]", "3"], {-1., 0}], 
   PolygonBox[{{0.6944053606624674, 0.0521409583523193}, {0.7950961894323343, 
    0.05490381056766585}, {0.7423580748420087, 0.1407232001028063}}], 
   CircleBox[{5.551115123125783*^-17, -1.3222431864335464`}, 
    1.5901923788646695, {1.047197551196598, 2.094395102393195}], 
   InsetBox["\<\"a\"\>", {1.5288235157151446*^-16, 0.26794919243112303}, 
    NCache[ImageScaled[{Rational[1, 2], 1}], ImageScaled[{0.5, 1}]]], 
   CircleBox[{-1.2868691777028887`, -0.07685099143191673}, 
    0.10606601717798213, {0.7853481633974488, 6.021335919380437}], 
   PolygonBox[{{-1.304802012823478, -0.014085347722943793`}, \
{-1.2118654277966403`, -0.0018547415256651295`}, {-1.268925735980586, 
    0.07251539894990955}}], 
   InsetBox["\<\"c,b\"\>", {-1.3143159603571446, 0.025602286319114903}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-1., 0.4242640687119285}, {-1., 0.21213203435596426`}}], 
    PolygonBox[{{-1., 0.21213203435596426`}, {-1.0707106781186548`, 
     0.31819805153394637`}, {-0.9292893218813453, 0.31819805153394637`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{
  3.967117299509762*^9, {3.96711843745339*^9, 3.9671184477546387`*^9}},
 CellLabel->"Out[14]=",ExpressionUUID->"532acf3b-b900-4e60-8101-a4064480bc88"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118447756256*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"63245cf2-5fd9-4568-8f63-51b41fb141ea"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118447756729*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"bd09e366-1687-404f-8446-3ee9096453b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118447757244*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"cf360eeb-1806-4326-9cab-06ef76bcce25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.9671184477576036`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"34a3818d-7c80-4e34-a600-45ac7a1aa8f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118447757988*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"79c869e4-6313-4919-b70e-87983e227aad"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.96711844785982*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"a53d8815-2691-4497-85fd-beaa50fbea52"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.9671184488659887`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"13bee82c-e099-4602-b70c-389d99de1d1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/aut2/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118448869484*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"3fe4219c-a7db-4cfe-9ea5-113852713554"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"aut2\"\>"}],
  SequenceForm["Archivo: ", "aut2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.9671184488717003`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"4e1d6aa4-f1ca-4dd1-bf3f-f79d8f6c1603"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.96711844940333*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"170d74b2-eaf6-45d1-9b49-0680774f5d25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut2/aut2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/aut2/aut2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967117299511663*^9, {3.967118437455002*^9, 3.967118449403872*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"fa6a942a-8522-435d-ab42-0c98629a351d"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/aut2/aut2.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.967117299509762*^9, {3.96711843745339*^9, 3.9671184494161787`*^9}},
 CellLabel->"Out[17]=",ExpressionUUID->"8617b97b-f990-424c-8b40-062fa81587d3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3", "Subsection",
 CellChangeTimes->{{3.967116565490749*^9, 
  3.967116584285492*^9}},ExpressionUUID->"7c74d08a-1b2b-4c86-afcc-\
d9452e4b9410"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataDRandom", "[", 
  RowBox[{"5", ",", "4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aut3", "=", 
   RowBox[{"ComponentesAutomata", "[", 
    RowBox[{"G", ",", 
     RowBox[{"conjuntos", "->", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportAutomataToTikZ", "[", 
   RowBox[{
    RowBox[{"aut3", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"aut3", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"aut3", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"aut3", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"aut3", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<aut3.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "0.5"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "4.2"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96711662930583*^9, 3.9671166315680428`*^9}, {
   3.967117065000626*^9, 3.967117065285755*^9}, {3.967117105381147*^9, 
   3.967117118266839*^9}, 3.967117205484536*^9, 3.9671173352283154`*^9, 
   3.967117528315536*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"2a959b34-758c-4610-ab36-1bdcdec79a02"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.30901699437494723`, -0.9510565162951536}, 0.1763355756877419],
    CircleBox[{0.30901699437494723`, -0.9510565162951536}, 
    0.1175570504584946], InsetBox[
    SubscriptBox["\[Sigma]", 
     "0"], {0.30901699437494723, -0.9510565162951536}], 
   PolygonBox[{{0.8710391673520581, -0.15561018349002384`}, {
    0.9368069813088937, -0.16462344195719167`}, {
    0.8961173635270334, -0.21707341036159614`}}], 
   CircleBox[{1.2239283324665529`, -0.9444059076681816}, 0.830962913805972, {
    1.9235982181628124`, 2.97079576935941}], 
   InsetBox["\<\"c\"\>", {0.5853827155396125, -0.4126551585156256}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7807450139637571, 
    0.33910939104956717`}, {-0.7458404383439745, 
    0.4231554918565402}, {-0.6905066677659992, 0.35090419225800706`}}], 
   CircleBox[{0.8070673453032899, 0.5863898031950079}, 1.5614634241346816, {
    3.2463233167334122`, 4.29352086793001}], 
   InsetBox["\<\"d,b\"\>", {-0.45617308940059664, -0.3314291490169957}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.645065394871321, -0.7484092143051304}, \
{-0.6611391416271251, -0.6838392783393843}, {-0.5971830633821524, \
-0.7022039732977332}}], 
   CircleBox[{-0.04068339500867225, -0.12515549531314502`}, 
    0.8349208962101571, {3.874651339540189, 4.921748890736787}], 
   InsetBox["\<\"a\"\>", {-0.29871164477977563, -0.9192048169855667}, 
    ImageScaled[{1, 1}]], CircleBox[{1., 0}, 0.1763355756877419], 
   CircleBox[{1., 0}, 0.1175570504584946], InsetBox[
    SubscriptBox["\[Sigma]", "1"], {1., 0}], 
   PolygonBox[{{-0.6382063227625887, 0.4038170862999431}, {-0.661139141627125,
     0.491731226245562}, {-0.5735368536500907, 0.4676345599898279}}], 
   CircleBox[{0.4739007625669182, 1.5565450016909628`}, 1.556323861055633, {
    3.895078563668206, 4.942176114864804}], 
   InsetBox["\<\"b\"\>", {0.02325977572516441, 0.06689179994587091}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.2465314794736215`, 0.012920167362575232`}, 
    0.08816778784387096, {-2.565634000431664, 2.6703537555513246`}], 
   PolygonBox[{{1.206133177364866, -0.1054289009382299}, {
    1.1725877507681106`, -0.03509945152812033}, {
    1.2502675538898156`, -0.0412129846195988}}], 
   InsetBox["\<\"d,c,a\"\>", {1.2511458249602556, -0.07512678959228959}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.30901699437494745`, 0.9510565162951535}, 0.1763355756877419], 
   CircleBox[{0.30901699437494745`, 0.9510565162951535}, 0.1175570504584946], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.30901699437494745, 0.9510565162951535}],
    PolygonBox[{{0.31807951129044054`, -0.6842924051638096}, {
    0.31824568534821523`, -0.774962602385424}, {
    0.3966852924793912, -0.729483592819134}}], 
   CircleBox[{-1.0108179776830866`, 0.03441567081123406}, 
    1.5561180577041662, {5.736086226400195, 6.783383777596792}], 
   InsetBox["\<\"d,c,a\"\>", {0.5448722318868195, -0.0020724280886601706}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.45412342555620844`, 1.1507783847171358`}, 
    0.08816778784387096, {-1.675516081914556, 3.5604716740684323`}], 
   PolygonBox[{{0.498543973812682, 1.1196147634872018`}, {
    0.44490738218318016`, 1.0630935892402213`}, {0.5206744507475429, 
    1.044903525440151}}], 
   InsetBox["\<\"b\"\>", {0.5254526642783449, 1.0989546592952568}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{-0.8090169943749473, 0.5877852522924732}, 0.1763355756877419], 
   InsetBox[
    SubscriptBox["\[Sigma]", "3"], {-0.8090169943749473, 0.5877852522924732}],
    PolygonBox[{{0.0703867387990544, 0.9190940680724132}, {0.1329230804652178,
     0.9418278253218856}, {0.08196689833062439, 0.9846190072397901}}], 
   CircleBox[{-0.040665785663454176`, 0.1251564190627104}, 
    0.8349163312842653, {1.3613568165555772`, 2.4085543677521746`}], 
   InsetBox["\<\"b\"\>", {-0.2986691209114757, 0.9192090364918541}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8302140333383264, 0.17908791415356162`}, {
    0.9199453238716613, 0.15711614838428972`}, {0.8941077859271848, 
    0.2458116083851557}}], 
   CircleBox[{-0.22145219381429884`, -0.9769967367013951}, 
    1.6090370814549453, {0.7821968562506261, 1.8293944074472233`}], 
   InsetBox["\<\"a\"\>", {0.19997060977539907, 0.5758725913850499}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-1.0537747949251535`, 0.6200082280389055}, 
    0.08816778784387096, {0.3926990816987246, 5.6286868376817125`}], 
   PolygonBox[{{-1.047583325031883, 0.6739157608717964}, {-0.9723183803094037,
     0.6537485797150352}, {-0.9924855614661652, 0.7290135244375143}}], 
   InsetBox["\<\"d,c\"\>", {-1.0422665893014276, 0.7074217282354077}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{-0.8090169943749475, -0.587785252292473}, 0.1763355756877419], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {-0.8090169943749475, -0.587785252292473}],
    PolygonBox[{{0.7444939968693494, -0.07806200308264682}, {
    0.8309259700712491, -0.05008200931251861}, {0.763478598067638, 
    0.010780278294478307`}}], 
   CircleBox[{0.4673904649928002, -1.5630719848607335`}, 1.5560516474596955, {
    1.3349901906661232`, 2.3821877418627206`}], 
   InsetBox["\<\"d,b,a\"\>", {0.025726459794236434, -0.07101647782555776}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.9110991583431007, 0.3822191589995274}, {-0.854655999692052,
     0.41745816564213256`}, {-0.8523597040609516, 0.35095745305918635`}}], 
   CircleBox[{-0.1315972467653742, 1.1102230246251565`*^-16}, 
    0.8349163312842653, {2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"c\"\>", {-0.9665135780496396, 2.1327006372882833*^-16}, 
    NCache[ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-0.8090169943749473, 0.940456403667957}, {-0.8090169943749473, 
     0.7641208279802152}}], 
    PolygonBox[{{-0.8090169943749473, 
     0.7641208279802152}, {-0.8677955196041947, 
     0.8522886158240861}, {-0.7502384691457, 0.8522886158240861}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.967117336179357*^9, 3.967117351930046*^9}, {
  3.9671174156267347`*^9, 3.967117430415284*^9}, {3.9671175309977617`*^9, 
  3.96711754448155*^9}, {3.967118463587204*^9, 3.967118481130494*^9}},
 CellLabel->"Out[22]=",ExpressionUUID->"6f25cbbb-c6ec-4204-9912-a00a1e5f2771"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.9671184811320953`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"ccdc2511-8e29-4199-8577-fff299727b0c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.9671184811325397`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"81e16bf1-65e2-4087-bd9b-ce3f394017a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.9671184811330233`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"2fa40f97-4f59-4aa1-b602-b2f135430f65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118481133358*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"e58e2519-0995-46e2-9732-3cf23d866982"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.9671184811336603`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"ff343306-2b4b-4d36-b46d-75b4cd7fc119"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118481228714*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"98b59290-51cf-4967-b546-86e66176d2d7"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118482235304*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"62723691-be97-49fd-af15-e05b932c789e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/aut3/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118482238223*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"18cf52be-5003-4144-9eba-b4eff7485cde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"aut3\"\>"}],
  SequenceForm["Archivo: ", "aut3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118482239963*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"fdc96414-bc43-4b3b-b6be-4f1fef68ac17"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.9671184827661457`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"e958610d-c408-4889-b903-3dbe5b266229"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut3/aut3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/aut3/aut3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671173361864147`*^9, 3.9671173519366713`*^9}, {
  3.967117415644086*^9, 3.967117430417282*^9}, {3.967117530999474*^9, 
  3.967117544483302*^9}, {3.967118463588807*^9, 3.967118482766685*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"c4320027-3000-4eb7-a37e-af256066d1d7"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/aut3/aut3.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.967117336179357*^9, 3.967117351930046*^9}, {
  3.9671174156267347`*^9, 3.967117430415284*^9}, {3.9671175309977617`*^9, 
  3.96711754448155*^9}, {3.967118463587204*^9, 3.9671184827789993`*^9}},
 CellLabel->"Out[25]=",ExpressionUUID->"655c55c6-ab66-40ff-97c3-d3f2017e80a2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4", "Subsection",
 CellChangeTimes->{{3.967116565490749*^9, 
  3.9671165863291817`*^9}},ExpressionUUID->"aec22804-c07c-40de-b1bb-\
8116c22d9ad5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataNDRandom", "[", 
  RowBox[{"6", ",", "4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aut4", "=", 
   RowBox[{"ComponentesAutomata", "[", 
    RowBox[{"G", ",", 
     RowBox[{"conjuntos", "->", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportAutomataToTikZ", "[", 
   RowBox[{
    RowBox[{"aut4", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"aut4", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"aut4", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"aut4", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"aut4", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<aut4.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "1.3"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "3.5"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9671166431051607`*^9, {3.967116975105938*^9, 3.96711699210174*^9}, {
   3.967117146718874*^9, 3.9671171471110086`*^9}, 3.967117199113854*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"b0b0d405-b49c-4ab8-8d08-2b8deca5169e"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{-1., 0}, 0.14999999999999986], InsetBox[
    SubscriptBox["\[Sigma]", "0"], {-1., 0}], 
   PolygonBox[{{0.7645433651846361, 0.020260219099714386`}, {
    0.8521865529578143, 0.025518324269178116`}, {0.8038113064186994, 
    0.09879049876466832}}], 
   CircleBox[{0.054258810736006406`, -1.4852154280968277`}, 
    1.7085096289881032, {1.084865702412924, 2.1320632536095214`}], 
   InsetBox["\<\"d,b,a\"\>", {-0.010082370298549657, 0.22208225091762723}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2837319292391459, 0.7870119998665367}, {
    0.35532502589984377`, 0.826412882164134}, {0.285406312568255, 
    0.8687138814590946}}], 
   CircleBox[{0.2896301045514376, -0.6521848674230369}, 1.4800564610092481, {
    1.5263949717882255`, 2.573592522984823}], 
   InsetBox["\<\"b\"\>", {-0.39277529945480766, 0.6611658063721583}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.6636856658702894, 
    0.7620134553415797}, {-0.6060660171779823, 
    0.7599593866064566}, {-0.6366547172298718, 0.7110863414493452}}], 
   CircleBox[{-0.2828364070041238, 0.09773362082806428}, 0.7368991421856336, {
    2.024875297884151, 3.0720728490807483`}], 
   InsetBox["\<\"d\"\>", {-0.8938743435592224, 0.5096231519458264}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.28437822097633597`, -0.7884551252157043}, {
    0.35511112605664075`, -0.8272025470190602}, {
    0.3533009251293457, -0.7465723434343648}}], 
   CircleBox[{-0.8946426523038091, -1.545784782425607}, 1.4416119226643802, {
    0.5218185322989694, 1.5690160834955669`}], 
   InsetBox["\<\"c,b,a\"\>", {-0.17161524947134588, -0.2985974226751027}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-1.2082047911532634`, -0.02740009016090756}, 
    0.07499999999999993, {0.6544484694978738, 5.890436225480862}], 
   PolygonBox[{{-1.2149837225747047`, 
    0.018257356018389202`}, {-1.1487010078504398`, 
    0.018254041882650222`}, {-1.1818394950868307`, 0.07565821373352996}}], 
   InsetBox["\<\"d\"\>", {-1.2179905376393019, 0.04695876382240082}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{-0.4999999999999996, -0.8660254037844388}, 0.14999999999999986],
    CircleBox[{-0.4999999999999996, -0.8660254037844388}, 0.0999999999999999],
    InsetBox[
    SubscriptBox["\[Sigma]", 
     "1"], {-0.4999999999999996, -0.8660254037844388}], 
   PolygonBox[{{0.3555484242460715, 0.7263586534343099}, {0.4431648492068885, 
    0.7272098224027932}, {0.40009377067609947`, 0.6509061881137111}}], 
   CircleBox[{1.2753043534326916`, -0.7569266323347917}, 1.7015043845885949, {
    2.081809273776478, 3.1290068249730756`}], 
   InsetBox["\<\"d,b\"\>", {-0.18741782408823449, 0.11230348803762935}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.6086856099057836, 
    0.6802453925579406}, {-0.5388228567653783, 
    0.7211365298410785}, {-0.5383414696587465, 0.6401880422015975}}], 
   CircleBox[{0.7055175575548367, -0.027788172225427607`}, 
    1.452333045852779, {2.5998031004467723`, 3.6470006516433697`}], 
   InsetBox["\<\"d\"\>", {-0.7465752032353765, -0.0013705618742486832}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-1.0669379177058593`, -0.1974650584308419}, \
{-1.038837345458634, -0.14488499093324567`}, {-1.0073519573966279`, \
-0.19551083410902098`}}], 
   CircleBox[{-0.2509587726825671, -0.1448743848618753}, 0.7878785728474541, {
    3.1416061151455916`, 4.188803666342189}], 
   InsetBox["\<\"d,c\"\>", {-0.9332763287683825, -0.5388228563771498}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.5543519994715289, -1.068869827305143}, 0.07499999999999993, {
    1.8325957145940466`, 7.068583470577035}], 
   PolygonBox[{{-0.6394790848476413, -1.0050770207072437`}, \
{-0.573763427854218, -0.9964253903334629}, {-0.5991287246630823, \
-1.0576626339030424`}}], 
   InsetBox["\<\"a\"\>", {-0.6267964364432089, -1.049458398922454}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.5000000000000009, -0.8660254037844382}, 0.14999999999999986], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.5000000000000009, -0.8660254037844382}],
    PolygonBox[{{0.9046082583199522, -0.14684221967817096`}, {
    0.9611771432346219, -0.1448888739433601}, {
    0.9345843478060072, -0.19485563821062785`}}], 
   CircleBox[{1.316288269291262, -0.759959386606456}, 0.710222252113279, {
    2.094395102393196, 3.141592653589793}], 
   InsetBox["\<\"d,c,a\"\>", {0.701217756628166, -0.4048482605498168}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.393656692916972, 0.6772253614653839}, {0.46117714323462183`,
     0.7211365298410786}, {0.46544510539900436`, 0.6407065204031813}}], 
   CircleBox[{1.7264830614531053`, 0.03834462988767387}, 1.437777397694337, {
    2.6467490424764883`, 3.693946593673086}], 
   InsetBox["\<\"b\"\>", {0.2893000427404009, -0.0029931983636758697}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.5786761483918579, 
    0.6416822194120249}, {-0.5388373454586342, 
    0.7211404128511929}, {-0.48994393286810856`, 0.6469099007350751}}], 
   CircleBox[{1.2109743234370003`, 0.7856754777863846}, 1.7510013281575536, {
    3.178457094105703, 4.225654645302301}], 
   InsetBox["\<\"d,c\"\>", {-0.27213950119746877, -0.14511936233018696}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.9592372955500588, -0.22768238113004657`}, \
{-0.9611916323161064, -0.1448927555045858}, {-0.8885165449716304, \
-0.184595063030369}}], 
   CircleBox[{0.3551005199852701, 0.615081119795128}, 1.5199293803819494, {
    3.6651984071908257`, 4.712295958387423}], 
   InsetBox["\<\"c,a\"\>", {-0.4049207992479075, -0.701183639157005}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.32885630295814844`, -0.9568418561392472}, \
{-0.3551111260566395, -0.9048482605498168}, {-0.2969559398928527, \
-0.9081077145693722}}], 
   CircleBox[{0.07764571353075625, -0.28977774788671984`}, 
    0.752057323451688, {4.099258358319991, 5.14635590951659}], 
   InsetBox["\<\"d,c,b\"\>", {0.0103651009467782, -1.0388194936710529}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6050000000000009, -1.04789073857917}, 
    0.07499999999999993, {-3.6651914291880914`, 1.5707963267948966`}], 
   PolygonBox[{{0.4996977345316092, -1.0629763517749689`}, {
    0.540048094716168, -1.0103907385791702`}, {
    0.5654133915250326, -1.0716279821487495`}}], 
   InsetBox["\<\"b,a\"\>", {0.540048094716168, -1.08539073857917}, 
    ImageScaled[{1, 1}]], CircleBox[{1., 0}, 0.14999999999999986], InsetBox[
    SubscriptBox["\[Sigma]", "3"], {1., 0}], 
   PolygonBox[{{-0.3659755699058046, 
    0.7105776522812992}, {-0.37010369008184113`, 
    0.7910124137784035}, {-0.2983810831899881, 0.7543700899721741}}], 
   CircleBox[{0.855096126056665, 1.5432279515534997`}, 1.4376866156211188, {
    3.692208848447626, 4.7393063996442235`}], 
   InsetBox["\<\"d,c\"\>", {0.17008652842880645, 0.27922452754950355}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.8129599732095419, -0.03830478072012202}, \
{-0.8551111260566399, 0.038822856765378035`}, {-0.767241056236771, 
    0.03676300718701555}}], 
   CircleBox[{0.06776200707178762, 1.4809578866461612`}, 1.7121472671062874, {
    4.143121680269831, 5.190219231466429}], 
   InsetBox["\<\"b\"\>", {-0.010487573756342988, -0.2294003411411496}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.2865878298361813, -0.8601611048214383}, \
{-0.3551111260566395, -0.9048482605498169}, {-0.2821492658627632, \
-0.9418475979635906}}], 
   CircleBox[{-0.4005312159152999, 0.58394297496484}, 1.489483913141739, {
    4.742787552117466, 5.789985103314064}], 
   InsetBox["\<\"d,b,a\"\>", {0.3830726874847618, -0.6827563777168507}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6729497194424923, -0.7747048005652114}, {
    0.6448888739433609, -0.82720254701906}, {
    0.7043836787633939, -0.8252550788460536}}], 
   CircleBox[{0.2509548911213428, -0.1448888739433604}, 0.7878679656440356, {
    5.235887755982989, 6.283185307179586}], 
   InsetBox["\<\"c\"\>", {0.9332488666450183, -0.5388569719566}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.2099999999999997`, 9.325873406851306*^-17}, 
    0.07499999999999993, {-2.6179938779914935`, 2.617993877991495}], 
   PolygonBox[{{1.1704133915250314`, -0.0987372435695793}, {
    1.145048094716167, -0.03749999999999993}, {
    1.2107637517095902`, -0.046151630373780644`}}], 
   InsetBox["\<\"d,c,b\"\>", {1.2099999999999997, -0.07499999999999983}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.4999999999999999, 0.8660254037844387}, 0.14999999999999986], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.4999999999999999, 0.8660254037844387}], 
   PolygonBox[{{0.5545229410129946, -0.646860216701003}, {
    0.557508788969122, -0.7274875418429998}, {
    0.6258411768032153, -0.6845880590901573}}], 
   CircleBox[{-0.7063794237448119, -0.019357997982796693`}, 
    1.44874458243159, {5.772384906190686, 6.819682457387284}], 
   InsetBox["\<\"d,c\"\>", {0.7422455804250968, -0.0007444970059640767}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.31999492472292856`, 
    0.7825953289357308}, {-0.3551111260566401, 
    0.8272025470190605}, {-0.29892204133746825`, 0.8353104604167989}}], 
   CircleBox[{-0.06724316041260418, 1.481095916447535}, 0.7144539902796818, {
    4.297683678989437, 5.344781230186036}], 
   InsetBox["\<\"c\"\>", {0.01036704190850403, 0.7708697829363579}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.8097748746127202, 
    0.04831112623123494}, {-0.8792412024411141, 
    0.08897928305022454}, {-0.8092883815965828, 0.12880480924773682`}}], 
   CircleBox[{-0.8357097524970417, 1.5243833617884706`}, 1.4360640154229294, {
    4.682071307266321, 5.729168858462919}], 
   InsetBox["\<\"d,a\"\>", {-0.15577029859912572, 0.2594872413795133}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.3331726441186948, -0.702165171126013}, \
{-0.37783518176304476`, -0.7789865780505645}, {-0.28897462298974635`, \
-0.7792547667857747}}], 
   CircleBox[{-1.218652824061009, 0.7649168794489205}, 1.7580137069085593, {
    5.210980772888315, 6.258178324084913}], 
   InsetBox["\<\"d,c\"\>", {0.28137667028905167, -0.15188392212046886}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{1.003726905196907, 0.1913745502417063}, {1.038822856765378, 
    0.1448888739433601}, {1.0615326575676107`, 0.19852569772081735`}}], 
   CircleBox[{0.28977968884844624`, 0.07763846903853322}, 
    0.7520560380469639, {0.08954167156094724, 1.1367392227575446`}], 
   InsetBox["\<\"c\"\>", {0.9048448983432691, 0.5104006120593688}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6484961363133718, 1.0145141154766089`}, 
    0.07499999999999993, {-1.832620714594046, 3.4033670413889423`}], 
   PolygonBox[{{0.6816695187641949, 0.9824192093448968}, {0.6290828968258247, 
    0.9420701638132772}, {0.6903195062438473, 0.9167033360812503}}], 
   InsetBox["\<\"d,b\"\>", {0.7015278190605754, 0.961479781078976}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.14999999999999986], 
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.0999999999999999], 
   InsetBox[
    SubscriptBox["\[Sigma]", "5"], {-0.5000000000000002, 0.8660254037844386}],
    PolygonBox[{{-0.48935767002785596`, -0.6360539359031878}, \
{-0.4889653154600495, -0.7164318352826354}, {-0.4195521899785217, \
-0.6759030965699004}}], 
   CircleBox[{-1.7200419532213356`, 0.026417610351178754`}, 
    1.43783691249046, {5.740158955464146, 6.787456506660744}], 
   InsetBox["\<\"a\"\>", {-0.28247497930319243, -0.0014424402577396557}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.33612811056942904`, 0.9649408369745446}, {
    0.39393398282201797`, 0.9720914209624208}, {0.35883845931032843`, 
    1.0185774828271428`}}], 
   CircleBox[{0.07764571353075626, 0.2897777478867197}, 0.7520573234516877, {
    1.136729397662998, 2.183926948859595}], 
   InsetBox["\<\"a\"\>", {0.010402553118152205, 1.038822856765378}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3992107508993409, -0.6519185425859652}, {
    0.44571174371176076`, -0.7261941296388368}, {
    0.4867857925743403, -0.6487852950356477}}], 
   CircleBox[{-1.2560466932404828`, -0.7491097576388377}, 
    1.7019127191911985, {0.013465038610897739`, 1.0606625898074953`}], 
   InsetBox["\<\"c,b\"\>", {0.2062615302646591, 0.12161497682895883}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8885025565696848, 0.18459089233615641`}, {0.961177143234622,
     0.1448888739433601}, {0.9592228064118321, 0.22767792140112766`}}], 
   CircleBox[{-0.3550966373633843, -0.6150743956732118}, 1.5199081671785568, {
    0.5236057543962683, 1.5708033055928654`}], 
   InsetBox["\<\"a\"\>", {0.4048482601615882, 0.7012099920568254}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.6050000000000002, 1.0478907385791705`}, 
    0.07499999999999993, {-0.5235987755982983, 4.71238898038469}], 
   PolygonBox[{{-0.5654133915250318, 1.07162798214875}, {-0.5400480947161673, 
    1.0103907385791706`}, {-0.4996977345316086, 1.0629763517749693`}}], 
   InsetBox["\<\"d,b,a\"\>", {-0.5400480947161674, 1.0853907385791706}, 
    ImageScaled[{0, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-1., 0.2999999999999997}, {-1., 0.14999999999999986`}}], 
    PolygonBox[{{-1., 0.14999999999999986`}, {-1.05, 
     0.22499999999999978`}, {-0.9500000000000001, 0.22499999999999978`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.967117441358658*^9, 3.9671174569619217`*^9}, {
  3.967117565796563*^9, 3.967117579017763*^9}, {3.967118494102003*^9, 
  3.967118502719619*^9}},
 CellLabel->"Out[30]=",ExpressionUUID->"8fe00089-32e9-4591-93ec-3a292ecad67f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.967118502725582*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"37cb2ea5-8121-4949-b15b-a85b14709c08"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.967118502726829*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"6f71743b-fc4c-49c5-97d8-2133d2e5923f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185027273006`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"aa63e099-7986-4cc4-bdec-36bf2c21ac8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.967118502727635*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"805c45c5-445d-4a4a-9b63-071edaf3408e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185027279387`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"40af12c8-82df-4a5a-a6ba-efaea43f8e94"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185028133383`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"09f6fbd7-8cfc-4729-856c-e66adab1b045"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185038198347`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"733d4998-1711-4fff-bd7c-2f6ec1c39af9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/aut4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.96711850382259*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"7a68c85c-3a9e-45fb-b33b-f0e4e192c51e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"aut4\"\>"}],
  SequenceForm["Archivo: ", "aut4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.96711850382417*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"4b75d1a3-97e7-4f48-9b4f-646d1a002eb8"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185044480677`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"866737f6-d708-4da7-8f3e-831f6c80312b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut4/aut4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/aut4/aut4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967117441361594*^9, 3.967117456974401*^9}, {
  3.967117565804582*^9, 3.9671175790226173`*^9}, {3.9671184941073837`*^9, 
  3.9671185044486313`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"23cafe0a-28fe-4ac2-8416-41d39e9b2f21"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/aut4/aut4.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.967117441358658*^9, 3.9671174569619217`*^9}, {
  3.967117565796563*^9, 3.967117579017763*^9}, {3.967118494102003*^9, 
  3.967118504461339*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"9eaa479f-6169-41af-87ec-58d77d9d1c33"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5", "Subsection",
 CellChangeTimes->{{3.967116565490749*^9, 3.967116588130209*^9}, 
   3.967117601058343*^9, 
   3.967117641932912*^9},ExpressionUUID->"6e963e72-1572-40f1-935c-\
48fba2a33a84"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataNDRandom", "[", 
  RowBox[{"7", ",", "5"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aut5", "=", 
   RowBox[{"ComponentesAutomata", "[", 
    RowBox[{"G", ",", 
     RowBox[{"conjuntos", "->", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportAutomataToTikZ", "[", 
   RowBox[{
    RowBox[{"aut5", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"aut5", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"aut5", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"aut5", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"aut5", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<aut5.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "2.5"}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<circular\>\"", ",", "\"\<grid\>\"", 
        ",", "\"\<spring\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<AutoColor\>\"", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9671166572942667`*^9, 3.967116659263832*^9}, {
   3.9671170707288923`*^9, 3.9671170722528477`*^9}, {3.967117169699246*^9, 
   3.967117191944312*^9}, {3.967117599906682*^9, 3.967117604203066*^9}, 
   3.967117644114853*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"47a1aac2-e1ca-4ac6-9785-724d853ff58c"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{-0.22252093395631434`, 0.9749279121818236}, 
    0.13016512173526743], InsetBox[
    SubscriptBox["\[Sigma]", 
     "0"], {-0.22252093395631434, 0.9749279121818236}], 
   PolygonBox[{{-0.17089510426758797`, -0.775139812015659}, \
{-0.16822317400025477`, -0.8566286637475622}, {-0.09898772340886958, \
-0.8135702783929595}}], 
   CircleBox[{-1.6558167244354198`, -0.02156282778658159}, 
    1.7059512072991752, {5.7715672104667295`, 6.818864761663328}], 
   InsetBox["\<\"e,d,c,b\"\>", {0.050011027022899945, -0.0010395717055804964},
     ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7389713956541232, 
    0.49385547454454864`}, {-0.7730729833010157, 
    0.4580829460959182}, {-0.725042271083454, 0.44643636910864287`}}], 
   CircleBox[{-0.9288101629383297, 1.06419362385196}, 0.6257988676973406, {
    4.963793468253346, 6.010991019449944}], 
   InsetBox["\<\"e,d,c,b\"\>", {-0.49092717623568066, 0.6171111786948713}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.780479601416028, -0.27634595291869296`}, \
{-0.808703458374727, -0.34206841838597074`}, {-0.7376742052013694, \
-0.33364976277134345`}}], 
   CircleBox[{-1.5689598451546318`, 0.727443765340103}, 1.312191329333551, {
    5.330255823781659, 6.377553374978256}], 
   InsetBox["\<\"e,d,c,b,a\"\>", {-0.37582971526863407, 0.1812875807771397}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6204739846307005, -0.5841518250514169}, {
    0.6591585154124897, -0.6566488087876157}, {
    0.7026004796348905, -0.5868985305290056}}], 
   CircleBox[{-1.0712093303107115`, -0.5631753819755232}, 
    1.7328906956391534, {6.229118363416997, 7.276415914613594}], 
   InsetBox["\<\"e,c,b,a\"\>", {0.4741091051297972, 0.220980913746476}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9236619141382283, 0.1677894238665007}, {0.9854261303379874, 
    0.12934667077057552`}, {0.987836423010592, 0.20205742759236384`}}], 
   CircleBox[{-0.2214941103240806, -0.47941461770741295`}, 
    1.3517569210731513, {0.4671552800797234, 1.514352831276321}], 
   InsetBox["\<\"e,b\"\>", {0.5193488341919046, 0.6512482432861064}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.503658735378597, 0.9009894955410507}, {0.5542377818520476, 
    0.8920454409367762}, {0.5366940371154593, 0.9403202073841155}}], 
   CircleBox[{0.10399369420816448`, 0.3905809506243946}, 0.6739335082206028, {
    0.8391657092770015, 1.8863632604735987`}], 
   InsetBox["\<\"d,c\"\>", {0.24318426685532388, 1.049983982152674}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.252916815740139, 1.1546062076062946`}, 
    0.06508256086763371, {-0.8796157898646115, 4.356371966118377}], 
   PolygonBox[{{-0.21353952350230918`, 
    1.1619397747790514`}, {-0.2114301180589046, 
    1.1044604835154501`}, {-0.16270629435480313`, 1.1350269278481204`}}], 
   InsetBox["\<\"d,b\"\>", {-0.1887459959456851, 1.1654618796719463}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{-0.900968867902419, 0.43388373911755823`}, 0.13016512173526743],
    InsetBox[
    SubscriptBox["\[Sigma]", "1"], {-0.900968867902419, 0.43388373911755823}],
    PolygonBox[{{-0.8775214193702192, -0.25706977724392527`}, \
{-0.876571739063122, -0.3060254620262577}, {-0.8346497125355075, \
-0.2807251723636715}}], 
   CircleBox[{-1.40382061540101, 0.009111392678241771}, 0.6142496355657122, {
    5.744358418227928, 6.791655969424525}], 
   InsetBox["\<\"e,a\"\>", {-0.789641732395257, -0.00021139995142713426}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4430406090131727, 0.8315945733280679}, {0.5132758433899871, 
    0.8510835024747156}, {0.461280318468028, 0.9021645351124672}}], 
   CircleBox[{0.14325987428557863`, -0.45439234174947296`}, 
    1.3569005111816905, {1.2946063163339654`, 2.3418038675305626`}], 
   InsetBox["\<\"d\"\>", {-0.18903481877617961, 0.8611908879278155}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.4006190611409015, 
    1.0068143237424636`}, {-0.3518676047268899, 
    0.9895017818438361}, {-0.39123643402218966`, 0.955938053067126}}], 
   CircleBox[{-0.24996946446396445`, 0.3134517940645981}, 
    0.6836861977291562, {1.7203959769658388`, 2.7675935281624366`}], 
   InsetBox["\<\"d\"\>", {-0.6762408364196669, 0.8479791875781149}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.28326533933179726`, -0.7847999743946344}, \
{-0.24912226163234932`, -0.8475099845490559}, {-0.21188533861676423`, \
-0.7865862068207373}}], 
   CircleBox[{-1.5552082723965899`, -0.7838983330108624}, 
    1.3076341650956755, {6.234419733000332, 7.2817172841969295`}], 
   InsetBox["\<\"c,a\"\>", {-0.3922688855468759, -0.1860027800594497}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4888417394254531, -0.6208371561476297}, {
    0.5529170109947821, -0.672458542002712}, {
    0.5655848067391775, -0.5911570361417452}}], 
   CircleBox[{-1.0722929278672282`, -1.262801813212214}, 1.7291074354238942, {
    0.3484219802773113, 1.3956195314739088`}], 
   InsetBox["\<\"c,a\"\>", {0.040008530065476444, 0.06105542603942671}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8316462355606216, 0.11400478945274499`}, {0.912565458253354,
     0.09642696627972386}, {0.8873286883180549, 0.17529398037263094`}}], 
   CircleBox[{-0.2913018647019144, -1.175336860445868}, 1.7511938105895666, {
    0.8128172269958809, 1.860014778192478}], 
   InsetBox["\<\"e\"\>", {0.11539590640051778, 0.5279765825902398}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-1.07862909468899, 0.4744428724194894}, 0.06508256086763371, {
    0.2991493003418859, 5.535137056324874}], 
   PolygonBox[{{-1.0703615621818605`, 
    0.5136347115917501}, {-1.0164370102996183`, 
    0.49362318441889436`}, {-1.0260687953405239`, 0.550328979823036}}], 
   InsetBox["\<\"e,c,a\"\>", {-1.0641436899383003, 0.5378929534146933}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{-0.9009688679024191, -0.433883739117558}, 0.13016512173526743], 
   CircleBox[{-0.9009688679024191, -0.433883739117558}, 0.08677674782351161], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {-0.9009688679024191, -0.433883739117558}],
    PolygonBox[{{0.793994942056108, 0.00809415015716318}, {0.8730787803633776,
     0.028878416201537915`}, {0.8155371588163, 0.086974896182227}}], 
   CircleBox[{0.38914682338917317`, -1.6087286919372628`}, 
    1.7076144704258072, {1.2834623664404505`, 2.330659917637048}], 
   InsetBox["\<\"e,c,a\"\>", {-0.010559362237448133, 0.05144664361601148}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.41745412638893037`, 0.7910309920548202}, {
    0.4946467470780301, 0.7633267222390071}, {0.4320578352796876, 
    0.7103280866454571}}], 
   CircleBox[{0.7655197966678025, -0.9330083746516087}, 1.7178256517868626, {
    1.7291408608497851`, 2.7763384120463828`}], 
   InsetBox["\<\"d,c,b,a\"\>", {-0.31723069392281067, 0.4006243877919158}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.41796578595173245`, 
    0.9236889947719574}, {-0.3453816225497926, 
    0.9319370978758192}, {-0.37453063742978493`, 0.8649533169053677}}], 
   CircleBox[{0.43935461211055976`, -0.18243191311903703`}, 
    1.3629487336853732, {2.184334071294235, 3.2315316224908326`}], 
   InsetBox["\<\"e,c,b,a\"\>", {-0.7974314078728799, 0.39027184226247325}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.9797764317446109, 
    0.28537080471971604`}, {-0.9346580804155943, 
    0.30815388635140284`}, {-0.9374865286105671, 0.25768870710775965`}}], 
   CircleBox[{-0.40091989270515893`, -0.06737842502635052}, 
    0.6526108870599217, {2.5284620315250947`, 3.5756595827216917`}], 
   InsetBox["\<\"e,d,a\"\>", {-1.0509168779211397, -0.00902699728654549}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.3641915104783523, -0.8635986493765352}, \
{-0.3286785137469171, -0.8996050924698741}, {-0.3152525176938844, \
-0.850846713589268}}], 
   CircleBox[{-0.96608628970262, -1.0430631690158236`}, 0.6533520433694678, {
    0.22137615330716862`, 1.268573704503766}], 
   InsetBox["\<\"d,c,b,a\"\>", {-0.4858040014282161, -0.6001209423711276}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.2225209339563146, -0.9749279121818236}, 0.13016512173526743],
    InsetBox[
    SubscriptBox["\[Sigma]", 
     "3"], {-0.2225209339563146, -0.9749279121818236}], 
   PolygonBox[{{0.44811149798084865`, -0.7798033348596242}, {
    0.4945870482782218, -0.7637472618401205}, {
    0.4574443060096272, -0.7315262911374857}}], 
   CircleBox[{0.3565223626852164, -1.365755562264498}, 0.617637313629725, {
    1.3453547083362363`, 2.3925522595328346`}], 
   InsetBox["\<\"e,c,b,a\"\>", {0.17508573756208157, -0.7753687380113898}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.813710074976853, -0.029108852126474356`}, {
    0.8811649861866027, -0.053114954658049544`}, {
    0.8266476359435299, -0.09952957010992886}}], 
   CircleBox[{1.0871909986222335`, -1.3461191920089388`}, 
    1.3093153461284572, {1.7288070295614975`, 2.776004580758095}], 
   InsetBox["\<\"e,c,b,a\"\>", {0.26226511933712415, -0.3293576814799599}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4571088005041617, 0.6759491831865635}, {0.5383865478418969, 
    0.6833408987957683}, {0.5041490876681507, 0.6092564470343141}}], 
   CircleBox[{1.4897753149186035`, -0.7268310179099207}, 1.7010953591098688, {
    2.1643134432485023`, 3.2115109944450997`}], 
   InsetBox["\<\"c,a\"\>", {-0.03923748459782517, 0.018719302122246484}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.3271396765829117, 
    0.8082146151139896}, {-0.2562101464694896, 
    0.8491980594156683}, {-0.2561822076263623, 0.767279562308112}}], 
   CircleBox[{1.2102724558135354`, -0.037760515313425794`}, 
    1.713845598671088, {2.597636287693754, 3.6448338388903516`}], 
   InsetBox["\<\"e,d,c,b,a\"\>", {-0.5032180193360232, -0.002873158635103755},
     ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.9839614958170896, 0.2493629189896839}, {-0.943971968062308,
     0.31102735021980676`}, {-0.9105637679844939, 0.2455631876837616}}], 
   CircleBox[{0.43176199274566635`, 0.2079395718459365}, 1.3795908889850128, {
    3.066799499760185, 4.113997050956782}], 
   InsetBox["\<\"e,d,a\"\>", {-0.8112024553499602, -0.39065077366657863}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.8924375539568904, -0.6146138510828641}, \
{-0.8864079329803314, -0.563231866628364}, {-0.8449246396341566, \
-0.5941446637965057}}], 
   CircleBox[{-0.24997719340797317`, -0.31344132062134694`}, 
    0.6836954023153167, {3.5156052405729477`, 4.562802791769545}], 
   InsetBox["\<\"c,b,a\"\>", {-0.6762471086234452, -0.8479816488747884}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.26307118419621134`, -1.1525901667029836`}, 
    0.06508256086763371, {1.869995627136782, 7.105983383119771}], 
   PolygonBox[{{-0.3389599195198667, -1.1000336617255864`}, \
{-0.28225460577585904`, -1.0903990414069515`}, {-0.30226343669610733`, \
-1.1443245937981465`}}], 
   InsetBox["\<\"e,d\"\>", {-0.3265219893823399, -1.1381079344744491}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.6234898018587334, -0.7818314824680299}, 0.13016512173526743], 
   CircleBox[{0.6234898018587334, -0.7818314824680299}, 0.08677674782351161], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.6234898018587334, -0.7818314824680299}],
    PolygonBox[{{0.9017277121669052, -0.12594808229937307`}, {
    0.9501879644401281, -0.12025689181805362`}, {
    0.9308865538381155, -0.16507029660112701`}}], 
   CircleBox[{1.2964833569341792`, -0.6202339886316831}, 0.6081920718003437, {
    2.176553776828494, 3.2237513280250916`}], 
   InsetBox["\<\"e,c\"\>", {0.7465942014140131, -0.36038881772771364}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5287546677623396, 0.6185975139900814}, {0.5898005893455583, 
    0.6561016297018745}, {0.5917571455068329, 0.5844822529574778}}], 
   CircleBox[{1.7275663344412844`, 0.004732005209516797}, 
    1.3110275658522776, {2.6216400569127982`, 3.6688376081093956`}], 
   InsetBox["\<\"d,b\"\>", {0.4165474833864764, -0.000048225274433554705}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.2623517623282919, 
    0.776431040822832}, {-0.21729330086402904`, 
    0.8448678077354199}, {-0.1805545528969849, 0.7716276519956321}}], 
   CircleBox[{1.4919780549521893`, 0.7089526592403341}, 1.7146665843260187, {
    3.062243185574799, 4.109440736771397}], 
   InsetBox["\<\"e,a\"\>", {-0.05625193539326956, -0.027977047311896097}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.8943115175657714, 
    0.2225313820826777}, {-0.8864079329803313, 
    0.3045356116067523}, {-0.8193419792874328, 0.25668879181276477`}}], 
   CircleBox[{0.7054269495345753, 0.990601323924642}, 1.7333852586224163, {
    3.54852634706809, 4.595723898264687}], 
   InsetBox["\<\"c,a\"\>", {-0.33010964119460673, -0.3994664528655706}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.8084497386898799, -0.6138168380143421}, \
{-0.8317278696378217, -0.5441046222372237}, {-0.7597162543467639, \
-0.5588012773722444}}], 
   CircleBox[{0.10662549558705141`, 0.46721332131050747`}, 
    1.3795908889850124, {3.96439740078584, 5.011494951982438}], 
   InsetBox["\<\"e,b\"\>", {-0.20042063445234115, -0.8777750410920411}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.07589506140624723, -1.0809304576597678`}, \
{-0.1123069754875681, -1.0441799321885095`}, {-0.062274129786370966`, \
-1.0310215523292983`}}], 
   CircleBox[{0.08921306896641733, -0.3908679939472015}, 0.6836861977291562, {
    4.413189680042805, 5.460287231239402}], 
   InsetBox["\<\"e,d,b\"\>", {0.24131423279012937, -1.0574203571781957}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7371090782022292, -0.9243055485967119}, 
    0.06508256086763371, {-3.515591779017149, 1.7203959769658397`}], 
   PolygonBox[{{0.6487028954521565, -0.9508693061626842}, {
    0.6765254307960104, -0.9005282191409424}, {
    0.706210823339035, -0.9497937850572812}}], 
   InsetBox["\<\"e,b,a\"\>", {0.6862254831562713, -0.9648838615765318}, 
    ImageScaled[{1, 1}]], CircleBox[{1., 0}, 0.13016512173526743], InsetBox[
    SubscriptBox["\[Sigma]", "5"], {1., 0}], 
   PolygonBox[{{0.6801877331331312, 0.6431212276378301}, {0.7083850055814623, 
    0.6831615108392035}, {0.7289622717844095, 0.638721814980831}}], 
   CircleBox[{1.3163043295447505`, 0.6070359961770808}, 0.6126671187770357, {
    3.0170180421414767`, 4.064215593338075}], 
   InsetBox["\<\"e,d,b\"\>", {0.7517679942100194, 0.3690029637689999}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.17741727834568302`, 
    0.783944520330405}, {-0.17067586365387344`, 
    0.8555334081136214}, {-0.11204877555083934`, 0.8139007278414605}}], 
   CircleBox[{1.0424487128370776`, 1.3772182333006922`}, 1.32054015270904, {
    3.5477194136522896`, 4.5949169648488875`}], 
   InsetBox["\<\"e,d,c\"\>", {0.2526944242342103, 0.31886363367436954}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.762671902716801, 0.291274831423402}, {-0.7882457067165113, 
    0.36879573831393203`}, {-0.7083237300250489, 0.3521828488038203}}], 
   CircleBox[{0.37092218633674306`, 1.6147848885707567`}, 1.70181055550941, {
    3.9630731076323746`, 5.010170658828972}], 
   InsetBox["\<\"d,c,b\"\>", {-0.010035012804292809, -0.04383826913139721}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7324795318238062, -0.4352376555714803}, \
{-0.7858878800788678, -0.3730616612353235}, {-0.7053377153506679, \
-0.35789667204035225`}}], 
   CircleBox[{-0.18435228029083034`, 1.2338404838253965`}, 
    1.7158028970756227, {4.35419278058351, 5.401290331780109}], 
   InsetBox["\<\"e,d,c\"\>", {0.09806906189533704, -0.458559518269517}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.03690516264523449, -0.9424695326855795}, \
{-0.09317426318573904, -0.9895017818438361}, {-0.02430859034731734, \
-1.0147161277808854`}}], 
   CircleBox[{-0.29879024380834523`, 0.3746711150162341}, 1.3795816844301, {
    4.861888630555633, 5.9090861817522295`}], 
   InsetBox["\<\"e,c\"\>", {0.5612570029249675, -0.7040152886254547}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7672282992746174, -0.6915925150827407}, {
    0.7463504904522117, -0.7388406681620256}, {
    0.7977074957119713, -0.7332973044379414}}], 
   CircleBox[{0.36121634185012635`, -0.17395262213352455`}, 
    0.6836861977291565, {5.31068758106846, 6.357985132265057}], 
   InsetBox["\<\"e,b\"\>", {0.9771814886325125, -0.4706237446154824}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.1822311704293744`, 0.}, 
    0.06508256086763371, {-2.617993877991494, 2.6179938779914944`}], 
   PolygonBox[{{1.14787919902117, -0.08568096886026039}, {
    1.1258680193746566`, -0.03254128043381688}, {
    1.1828939293244034`, -0.04004888390589498}}], 
   InsetBox["\<\"e\"\>", {1.1822311704293744, -0.06508256086763371}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.6234898018587336, 0.7818314824680298}, 0.13016512173526743], 
   InsetBox[
    SubscriptBox["\[Sigma]", "6"], {0.6234898018587336, 0.7818314824680298}], 
   PolygonBox[{{0.7107056591364516, -0.6174803602969343}, {
    0.7155304421117133, -0.6897908422150498}, {
    0.7757407649250658, -0.6494572166316688}}], 
   CircleBox[{-0.4792223432004798, -0.06737842502635039}, 
    1.3471567967693752, {5.802814590549471, 6.850112141746068}], 
   InsetBox["\<\"d,b,a\"\>", {0.8666730446054649, -0.009094291983052658}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.07912760871625234, 
    0.9326442430477887}, {-0.09244635001482973, 
    0.9797819341025263}, {-0.044964541436395736`, 0.9677474568861585}}], 
   CircleBox[{0.34998467285058066`, 1.4039769081154967`}, 
    0.6129327744309306, {3.905951339691022, 4.95304889088762}], 
   InsetBox["\<\"e,c,a\"\>", {0.1788962258903681, 0.8154063267165105}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7241624116557265, 
    0.3490371020087774}, {-0.7753978852061008, 
    0.3996071112052633}, {-0.7059852357971442, 0.4186933282765702}}], 
   CircleBox[{-0.41111978745931055`, 1.672092613714303}, 1.3236003500277957, {
    4.43357295544435, 5.480670506640948}], 
   InsetBox["\<\"d\"\>", {-0.09041533048771538, 0.38793275689263074}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7085825288761338, -0.39504602961064245`}, \
{-0.7716221971318435, -0.4484576087795705}, {-0.6938465785874532, \
-0.47634577335069456`}}], 
   CircleBox[{-1.0488292447036602`, 1.2815259386790259`}, 
    1.7520521743660817, {4.871175134473917, 5.918372685670515}], 
   InsetBox["\<\"e,d,b\"\>", {0.05609490818819385, -0.07819073697702184}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.07643275532767116, -0.8333026036477081}, \
{-0.11087256265934349`, -0.9080130401196977}, {-0.028951523080940927`, \
-0.9004835699343728}}], 
   CircleBox[{-1.084027880761766, 0.5306192982850384}, 1.7368633447266102, {
    5.30703052345834, 6.354328074654937}], 
   InsetBox["\<\"d,c,a\"\>", {0.4780275480679901, -0.22877329814871306}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{1.0190673559966332`, 0.16864172326805174`}, {
    1.0429908143060043`, 0.1228606885934783}, {1.0706766241910355`, 
    0.16646952857305833`}}], 
   CircleBox[{0.36122483186383453`, 0.17394275556085423`}, 
    0.683676994187311, {6.208298945358627, 7.255596496555224}], 
   InsetBox["\<\"e\"\>", {0.9772073570397088, 0.4705565803548951}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7371162017635087, 0.9242998674548044}, 
    0.06508256086763371, {-1.7204459769658387`, 3.5155417790171497`}], 
   PolygonBox[{{0.7688396808160849, 0.8998463763285551}, {0.7274129316332524, 
    0.8599447101022774}, {0.7826821628299527, 0.8440189260268771}}], 
   InsetBox["\<\"e,d\"\>", {0.7879977678302139, 0.8837190103459561}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-0.9009688679024191, -0.17355349564702316`}, \
{-0.9009688679024191, -0.30371861738229056`}}], 
    PolygonBox[{{-0.9009688679024191, -0.30371861738229056`}, \
{-0.9443572418141749, -0.23863605651465686`}, {-0.8575804939906634, \
-0.23863605651465686`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.967117466066791*^9, 3.967117484843665*^9}, {
   3.967117587341778*^9, 3.967117645703019*^9}, 3.967118511075012*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"c7b7ce0e-abfe-4e2f-855c-412edbb303f9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185110868807`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"9b89ef8b-bc6d-4875-8aa0-8e8ab3d10d5e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185110873833`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"f4073546-d791-4e1c-9a91-032df289f71c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.967118511087851*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"27940360-9ee5-48c8-8150-77d435d51c5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.967118511088147*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"1b8198c0-babe-4bf3-bad4-50e7d112d97e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185110884457`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"3aa4cf7e-4d97-4a0e-a171-815a0496b1bd"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.967118511166917*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"a814ce1d-9c65-437c-9d6a-24da8786a53a"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185121726627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"8f5bdaf7-64e2-4bfa-a070-d43edd69eb63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/aut5/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185121756687`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"04545fb2-9f04-441b-9727-51b3b3f4f1a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"aut5\"\>"}],
  SequenceForm["Archivo: ", "aut5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185121791353`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"827c2488-431d-412e-906c-05ca871f57b2"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.967118512886779*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"0187d58e-835e-4307-b539-5d013c9f3de1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/aut5/aut5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/aut5/aut5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671174660804453`*^9, 3.9671174848568907`*^9}, {
   3.967117587355015*^9, 3.967117645712303*^9}, 3.9671185128872967`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"f2c6185d-0cc4-4f64-b3a3-bc192fc39e8b"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/aut5/aut5.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.967117466066791*^9, 3.967117484843665*^9}, {
   3.967117587341778*^9, 3.967117645703019*^9}, 3.967118512899575*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"c799fc06-41ca-4d75-ae05-a5870a76856d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9671165927686367`*^9, 
  3.9671166146540422`*^9}},ExpressionUUID->"f7e370e8-a405-4433-8183-\
b78610fc5f11"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1446, 688},
WindowMargins->{{Automatic, 25}, {Automatic, 0}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5420f22d-720b-4572-84cb-8f050efca9fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 280, 5, 99, "Input",ExpressionUUID->"bba70a38-bbed-491e-a5ca-9778f16b39ce"],
Cell[CellGroupData[{
Cell[881, 31, 1025, 30, 86, "Print",ExpressionUUID->"e21ab988-80c4-433f-94a6-53bdc92979e1"],
Cell[1909, 63, 251, 4, 46, "Print",ExpressionUUID->"e3626628-055b-4013-910b-95529446f86e"],
Cell[2163, 69, 249, 4, 46, "Print",ExpressionUUID->"b106a480-96e8-443f-bf16-e74c70578477"],
Cell[2415, 75, 492, 10, 46, "Print",ExpressionUUID->"59a25819-e0f1-4cbd-a768-9998cd868ee6"],
Cell[2910, 87, 529, 11, 46, "Print",ExpressionUUID->"c2bd9f5c-fa8a-4b5c-af35-19dc9df5f05f"],
Cell[3442, 100, 496, 10, 46, "Print",ExpressionUUID->"0e2cdf1f-a402-44c0-b758-a789cf7b7081"],
Cell[3941, 112, 491, 10, 46, "Print",ExpressionUUID->"6a504144-ea80-4910-bfd5-f5dc605cfee9"],
Cell[4435, 124, 1030, 30, 86, "Print",ExpressionUUID->"a18995c1-ed9f-4467-b7ae-b4c5da4974dd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5514, 160, 433, 6, 136, "Subtitle",ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],
Cell[CellGroupData[{
Cell[5972, 170, 210, 3, 58, "Input",ExpressionUUID->"6f7b34e8-b14a-427d-b416-d24fd4ad9427"],
Cell[6185, 175, 172613, 3315, 6623, "Output",ExpressionUUID->"05c77937-562e-4d17-aa77-87ba2819340d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178835, 3495, 157, 3, 106, "Subsection",ExpressionUUID->"fda263c4-2be5-4d9f-9165-de0be1e4d9b5"],
Cell[CellGroupData[{
Cell[179017, 3502, 1603, 36, 393, "Input",ExpressionUUID->"305a6fd9-80d3-46f9-8bd2-7a76a7b964fa"],
Cell[180623, 3540, 4172, 74, 811, "Output",ExpressionUUID->"0bb8f63d-1491-4dff-a224-191aca4c5da6"],
Cell[CellGroupData[{
Cell[184820, 3618, 444, 9, 46, "Print",ExpressionUUID->"d71c19aa-4b34-4049-967f-3d3c56b7497e"],
Cell[185267, 3629, 235, 4, 46, "Print",ExpressionUUID->"f67a73f6-0554-44bd-881b-a2e4406fbe17"],
Cell[185505, 3635, 424, 9, 46, "Print",ExpressionUUID->"56ab22bd-f99c-45c5-9061-0f18066ff24b"],
Cell[185932, 3646, 452, 9, 46, "Print",ExpressionUUID->"d707ab3b-e4e2-45c0-a506-e038ccaa9d51"],
Cell[186387, 3657, 434, 10, 46, "Print",ExpressionUUID->"115b17af-db7f-442b-9430-6030ecf4621e"],
Cell[186824, 3669, 241, 4, 46, "Print",ExpressionUUID->"52fd7084-b6c9-4e3f-a47a-2054b4088253"],
Cell[187068, 3675, 242, 4, 46, "Print",ExpressionUUID->"a6c3c3ba-2f20-46ae-8b2f-3abad7d47821"],
Cell[187313, 3681, 466, 11, 46, "Print",ExpressionUUID->"8f8bdc29-7f0a-458e-bc7d-0cdf283e9358"],
Cell[187782, 3694, 349, 8, 46, "Print",ExpressionUUID->"870e01cd-9b8f-4c1a-b795-b799edc0275f"],
Cell[188134, 3704, 242, 4, 46, "Print",ExpressionUUID->"7ab66d29-9ebf-4161-9896-10dc2218aef1"],
Cell[188379, 3710, 464, 11, 46, "Print",ExpressionUUID->"b9032cb2-6038-4bc6-a867-3151d1ba9ef0"]
}, Open  ]],
Cell[188858, 3724, 233, 3, 66, "Output",ExpressionUUID->"30e31dbb-9373-44b8-8d9e-f09bc94d4384"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189140, 3733, 157, 3, 106, "Subsection",ExpressionUUID->"d725bf0f-39ed-4f50-a9b6-14f29f747bfe"],
Cell[CellGroupData[{
Cell[189322, 3740, 1603, 36, 393, "Input",ExpressionUUID->"7efc7bcd-cd0e-4958-a913-1cefa51f1749"],
Cell[190928, 3778, 5017, 87, 708, "Output",ExpressionUUID->"532acf3b-b900-4e60-8101-a4064480bc88"],
Cell[CellGroupData[{
Cell[195970, 3869, 471, 10, 46, "Print",ExpressionUUID->"63245cf2-5fd9-4568-8f63-51b41fb141ea"],
Cell[196444, 3881, 262, 5, 46, "Print",ExpressionUUID->"bd09e366-1687-404f-8446-3ee9096453b6"],
Cell[196709, 3888, 454, 10, 46, "Print",ExpressionUUID->"cf360eeb-1806-4326-9cab-06ef76bcce25"],
Cell[197166, 3900, 483, 10, 46, "Print",ExpressionUUID->"34a3818d-7c80-4e34-a600-45ac7a1aa8f6"],
Cell[197652, 3912, 461, 11, 46, "Print",ExpressionUUID->"79c869e4-6313-4919-b70e-87983e227aad"],
Cell[198116, 3925, 269, 5, 46, "Print",ExpressionUUID->"a53d8815-2691-4497-85fd-beaa50fbea52"],
Cell[198388, 3932, 273, 5, 46, "Print",ExpressionUUID->"13bee82c-e099-4602-b70c-389d99de1d1c"],
Cell[198664, 3939, 495, 12, 46, "Print",ExpressionUUID->"3fe4219c-a7db-4cfe-9ea5-113852713554"],
Cell[199162, 3953, 380, 9, 46, "Print",ExpressionUUID->"4e1d6aa4-f1ca-4dd1-bf3f-f79d8f6c1603"],
Cell[199545, 3964, 268, 5, 46, "Print",ExpressionUUID->"170d74b2-eaf6-45d1-9b49-0680774f5d25"],
Cell[199816, 3971, 493, 12, 46, "Print",ExpressionUUID->"fa6a942a-8522-435d-ab42-0c98629a351d"]
}, Open  ]],
Cell[200324, 3986, 260, 4, 66, "Output",ExpressionUUID->"8617b97b-f990-424c-8b40-062fa81587d3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[200633, 3996, 157, 3, 106, "Subsection",ExpressionUUID->"7c74d08a-1b2b-4c86-afcc-d9452e4b9410"],
Cell[CellGroupData[{
Cell[200815, 4003, 3239, 62, 873, "Input",ExpressionUUID->"2a959b34-758c-4610-ab36-1bdcdec79a02"],
Cell[204057, 4067, 6293, 110, 716, "Output",ExpressionUUID->"6f25cbbb-c6ec-4204-9912-a00a1e5f2771"],
Cell[CellGroupData[{
Cell[210375, 4181, 596, 11, 46, "Print",ExpressionUUID->"ccdc2511-8e29-4199-8577-fff299727b0c"],
Cell[210974, 4194, 387, 6, 46, "Print",ExpressionUUID->"81e16bf1-65e2-4087-bd9b-ce3f394017a0"],
Cell[211364, 4202, 579, 11, 46, "Print",ExpressionUUID->"2fa40f97-4f59-4aa1-b602-b2f135430f65"],
Cell[211946, 4215, 604, 11, 46, "Print",ExpressionUUID->"e58e2519-0995-46e2-9732-3cf23d866982"],
Cell[212553, 4228, 586, 12, 46, "Print",ExpressionUUID->"ff343306-2b4b-4d36-b46d-75b4cd7fc119"],
Cell[213142, 4242, 393, 6, 46, "Print",ExpressionUUID->"98b59290-51cf-4967-b546-86e66176d2d7"],
Cell[213538, 4250, 394, 6, 46, "Print",ExpressionUUID->"62723691-be97-49fd-af15-e05b932c789e"],
Cell[213935, 4258, 618, 13, 46, "Print",ExpressionUUID->"18cf52be-5003-4144-9eba-b4eff7485cde"],
Cell[214556, 4273, 501, 10, 46, "Print",ExpressionUUID->"fdc96414-bc43-4b3b-b6be-4f1fef68ac17"],
Cell[215060, 4285, 394, 6, 46, "Print",ExpressionUUID->"e958610d-c408-4889-b903-3dbe5b266229"],
Cell[215457, 4293, 616, 13, 46, "Print",ExpressionUUID->"c4320027-3000-4eb7-a37e-af256066d1d7"]
}, Open  ]],
Cell[216088, 4309, 383, 5, 98, "Output",ExpressionUUID->"655c55c6-ab66-40ff-97c3-d3f2017e80a2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[216520, 4320, 159, 3, 106, "Subsection",ExpressionUUID->"aec22804-c07c-40de-b1bb-8116c22d9ad5"],
Cell[CellGroupData[{
Cell[216704, 4327, 3167, 61, 873, "Input",ExpressionUUID->"b0b0d405-b49c-4ab8-8d08-2b8deca5169e"],
Cell[219874, 4390, 13411, 239, 663, "Output",ExpressionUUID->"8fe00089-32e9-4591-93ec-3a292ecad67f"],
Cell[CellGroupData[{
Cell[233310, 4633, 548, 11, 46, "Print",ExpressionUUID->"37cb2ea5-8121-4949-b15b-a85b14709c08"],
Cell[233861, 4646, 339, 6, 46, "Print",ExpressionUUID->"6f71743b-fc4c-49c5-97d8-2133d2e5923f"],
Cell[234203, 4654, 533, 11, 46, "Print",ExpressionUUID->"aa63e099-7986-4cc4-bdec-36bf2c21ac8b"],
Cell[234739, 4667, 558, 11, 46, "Print",ExpressionUUID->"805c45c5-445d-4a4a-9b63-071edaf3408e"],
Cell[235300, 4680, 540, 12, 46, "Print",ExpressionUUID->"40af12c8-82df-4a5a-a6ba-efaea43f8e94"],
Cell[235843, 4694, 349, 6, 46, "Print",ExpressionUUID->"09f6fbd7-8cfc-4729-856c-e66adab1b045"],
Cell[236195, 4702, 350, 6, 46, "Print",ExpressionUUID->"733d4998-1711-4fff-bd7c-2f6ec1c39af9"],
Cell[236548, 4710, 571, 13, 46, "Print",ExpressionUUID->"7a68c85c-3a9e-45fb-b33b-f0e4e192c51e"],
Cell[237122, 4725, 454, 10, 46, "Print",ExpressionUUID->"4b75d1a3-97e7-4f48-9b4f-646d1a002eb8"],
Cell[237579, 4737, 348, 6, 46, "Print",ExpressionUUID->"866737f6-d708-4da7-8f3e-831f6c80312b"],
Cell[237930, 4745, 572, 13, 46, "Print",ExpressionUUID->"23cafe0a-28fe-4ac2-8416-41d39e9b2f21"]
}, Open  ]],
Cell[238517, 4761, 334, 5, 98, "Output",ExpressionUUID->"9eaa479f-6169-41af-87ec-58d77d9d1c33"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[238900, 4772, 206, 4, 106, "Subsection",ExpressionUUID->"6e963e72-1572-40f1-935c-48fba2a33a84"],
Cell[CellGroupData[{
Cell[239131, 4780, 1850, 44, 494, "Input",ExpressionUUID->"47a1aac2-e1ca-4ac6-9785-724d853ff58c"],
Cell[240984, 4826, 19887, 353, 762, "Output",ExpressionUUID->"c7b7ce0e-abfe-4e2f-855c-412edbb303f9"],
Cell[CellGroupData[{
Cell[260896, 5183, 524, 10, 46, "Print",ExpressionUUID->"9b89ef8b-bc6d-4875-8aa0-8e8ab3d10d5e"],
Cell[261423, 5195, 315, 5, 46, "Print",ExpressionUUID->"f4073546-d791-4e1c-9a91-032df289f71c"],
Cell[261741, 5202, 505, 10, 46, "Print",ExpressionUUID->"27940360-9ee5-48c8-8150-77d435d51c5d"],
Cell[262249, 5214, 532, 10, 46, "Print",ExpressionUUID->"1b8198c0-babe-4bf3-bad4-50e7d112d97e"],
Cell[262784, 5226, 514, 11, 46, "Print",ExpressionUUID->"3aa4cf7e-4d97-4a0e-a171-815a0496b1bd"],
Cell[263301, 5239, 321, 5, 46, "Print",ExpressionUUID->"a814ce1d-9c65-437c-9d6a-24da8786a53a"],
Cell[263625, 5246, 324, 5, 46, "Print",ExpressionUUID->"8f5bdaf7-64e2-4bfa-a070-d43edd69eb63"],
Cell[263952, 5253, 548, 12, 46, "Print",ExpressionUUID->"04545fb2-9f04-441b-9727-51b3b3f4f1a1"],
Cell[264503, 5267, 431, 9, 46, "Print",ExpressionUUID->"827c2488-431d-412e-906c-05ca871f57b2"],
Cell[264937, 5278, 320, 5, 46, "Print",ExpressionUUID->"0187d58e-835e-4307-b539-5d013c9f3de1"],
Cell[265260, 5285, 546, 12, 46, "Print",ExpressionUUID->"f2c6185d-0cc4-4f64-b3a3-bc192fc39e8b"]
}, Open  ]],
Cell[265821, 5300, 306, 4, 98, "Output",ExpressionUUID->"c799fc06-41ca-4d75-ae05-a5870a76856d"]
}, Open  ]],
Cell[266142, 5307, 282, 5, 262, "Input",ExpressionUUID->"f7e370e8-a405-4433-8183-b78610fc5f11"]
}, Open  ]]
}, Open  ]]
}
]
*)

